/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content;

import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.content.AbstractClientContent;
import com.selima.fbi.ui.content.html.HtmlPane;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLEditorKit;

public abstract class WebBrowserContent
extends AbstractClientContent {
    protected boolean init;
    protected URL url;
    protected WebBrowserWidget widget;

    protected WebBrowserContent(MailServiceClientContext cctx, String icon, String text, URL url) {
        super(cctx, icon, text);
        this.url = url;
        this.widget = new CobraBrowserWidget();
        this.add(this.widget.getComponent(), "Center");
        this.setMinimumSize(new Dimension(0, 0));
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
    }

    @Override
    public BackendWork getOpeningWork() {
        if (!this.init) {
            this.init = true;
            return new WebBrowserOpeningWork();
        }
        return super.getOpeningWork();
    }

    static class JEditorPaneBrowserWidget
    implements WebBrowserWidget,
    HyperlinkListener {
        private JScrollPane scrollPane;
        private JEditorPane editorPane = new JEditorPane();

        JEditorPaneBrowserWidget() {
            this.editorPane.addHyperlinkListener(this);
            this.editorPane.setEditable(false);
            this.editorPane.setEditorKit(new HTMLEditorKit());
            this.scrollPane = new JScrollPane(this.editorPane);
        }

        @Override
        public Component getComponent() {
            return this.scrollPane;
        }

        @Override
        public void setURL(URL url) throws IOException {
            this.editorPane.setPage(url);
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    URL url = evt.getURL();
                    if (url != null) {
                        this.setURL(url);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class CobraBrowserWidget
    implements WebBrowserWidget,
    PropertyChangeListener {
        HtmlPane htmlPane = new HtmlPane(new Insets(2, 2, 2, 2));

        public CobraBrowserWidget() {
            this.htmlPane.addPropertyChangeListener("status", this);
        }

        @Override
        public Component getComponent() {
            return this.htmlPane;
        }

        @Override
        public void setURL(URL url) throws IOException {
            this.htmlPane.setHtmlURL(url);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            WebBrowserContent.this.getClientContext().getStatusBar().displayMessage((String)evt.getNewValue());
        }
    }

    static interface WebBrowserWidget {
        public Component getComponent();

        public void setURL(URL var1) throws IOException;
    }

    protected class WebBrowserOpeningWork
    extends AbstractClientContent.OpeningWork {
        protected WebBrowserOpeningWork() {
        }

        @Override
        public void invokeBackend(BackendOperationHandle handle) {
            try {
                WebBrowserContent.this.widget.setURL(WebBrowserContent.this.url);
            }
            catch (IOException e) {
                LogAPI.logSevere((Throwable)e);
            }
        }
    }
}

