/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content;

import com.selima.fbi.CancelException;
import com.selima.fbi.FormType;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.plugin.IPayrollPlugin;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.plugin.PluginType;
import com.selima.fbi.plugin.u2.PayrollErrorException;
import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.SelectionAction;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.ToolBar;
import com.selima.fbi.ui.common.table.Column;
import com.selima.fbi.ui.common.table.ContentTable;
import com.selima.fbi.ui.common.table.ContentTableColumn;
import com.selima.fbi.ui.common.table.ContentTableColumnModel;
import com.selima.fbi.ui.common.waitdlg.MultiRunPluginProgressModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.common.waitdlg.StorageInterrupter;
import com.selima.fbi.ui.content.AbstractTableContent;
import com.selima.fbi.ui.content.MultiSaveAction;
import com.selima.fbi.ui.content.detail.SubmitDetailContent;
import com.selima.fbi.ui.content.empsel.EmpSelectionBox;
import com.selima.fbi.ui.content.empsel.EmpSelectionEvent;
import com.selima.fbi.ui.content.empsel.EmpSelectionListener;
import com.selima.fbi.ui.content.result.PayrollErrorsContent;
import com.selima.fbi.ui.content.result.SubmissionContent;
import com.selima.fbi.ui.content.result.ValidationContent;
import com.selima.fbi.ui.content.sendtable.TypedPAYEMessageTableModel;
import com.selima.fbi.ui.content.settings.SettingsContent;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.fbi.user.IUser;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SubmitContent
extends AbstractTableContent<SubmitTable> {
    static final Format decimalFormat = new DecimalFormat("0.00");
    private ValidateMessagesAction validateMessagesAction;
    private ReadPayrollAction extractMessagesAction = new ReadPayrollAction();
    private ShowMessageDetailAction showDetailAction = new ShowMessageDetailAction();
    private SendMessagesAction sendMessagesAction;
    private SaveAction saveAction = new SaveAction();
    private ToolBar toolBar;
    private MessageTypeComboBox cmbMessageType;
    private EmpSelectionBox selEmpRefs;
    private TaxYearComboBox cmbTaxYear;

    public SubmitContent(MailServiceClientContext cctx) {
        super(cctx, "/img/32x32/mimetypes/mail_pen.png", "Preparing Submit screen", new SubmitTable(cctx));
        this.validateMessagesAction = new ValidateMessagesAction();
        this.sendMessagesAction = new SendMessagesAction();
        Object[] objectArray = new Object[9];
        this.selEmpRefs = new EmpSelectionBox(this.getClientContext(), false);
        objectArray[0] = this.selEmpRefs;
        objectArray[1] = Box.createHorizontalStrut(10);
        objectArray[2] = new JLabel("Message Type");
        objectArray[3] = Box.createHorizontalStrut(5);
        this.cmbMessageType = new MessageTypeComboBox();
        objectArray[4] = this.cmbMessageType;
        objectArray[5] = Box.createHorizontalStrut(10);
        objectArray[6] = new JLabel("Tax Year");
        objectArray[7] = Box.createHorizontalStrut(5);
        this.cmbTaxYear = new TaxYearComboBox();
        objectArray[8] = this.cmbTaxYear;
        this.toolBar = new ToolBar(objectArray);
        if (MailServiceConfig.isDevelopmentVersion()) {
            this.toolBar.addTool(Box.createHorizontalStrut(10)).addTool(new JLabel("Plugin")).addTool(Box.createHorizontalStrut(5)).addTool(new PluginTypeComboBox());
        }
        this.toolBar.addTool(Box.createHorizontalStrut(10)).addTool(this.extractMessagesAction).addTool(this.showDetailAction).addTool(this.saveAction).addTool(this.validateMessagesAction);
        this.wireupComponents();
        this.add((Component)new SouthPanel(), "South");
        for (Action action : this.toolBar.getActions()) {
            ((SubmitTable)this.table).getPopupMenu().add(action);
        }
        ((SubmitTable)this.table).addMouseListener(new DetailListener());
    }

    @Override
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public String getContentName() {
        return "Submit";
    }

    @Override
    public String getDescription() {
        return "Send prepared messages";
    }

    @Override
    public String getHelpTopic() {
        return "content.context-help.submit";
    }

    public void hideRow(IPAYEMessage message) {
        ((SubmitTable)this.table).hideRow(message);
    }

    private void showDetail(IPAYEMessage message) {
        this.getClientContext().displayContent(new SubmitDetailContent(this, this.getClientContext(), message));
    }

    private void wireupComponents() {
        this.extractMessagesAction.considerEnabling(this.selEmpRefs.getEmpRefs());
        this.selEmpRefs.addEmpSelectionListener(new EmpSelectionListener(){

            @Override
            public void selectionChange(EmpSelectionEvent evt) {
                SubmitContent.this.extractMessagesAction.considerEnabling(SubmitContent.this.selEmpRefs.getEmpRefs());
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                SubmitContent.this.extractMessagesAction.considerEnabling(SubmitContent.this.selEmpRefs.getEmpRefs());
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }
        });
    }

    class SaveAction
    extends MultiSaveAction {
        SaveAction() {
            super(SubmitContent.this.getClientContext(), SubmitContent.this.table);
        }

        @Override
        protected IMailMessage getMessage(int index) {
            return (IMailMessage)((SubmitTable)SubmitContent.this.table).getModel().getRowValue(index);
        }
    }

    class SendMessagesAction
    extends SelectionAction {
        SendMessagesAction() {
            super("Send", "/img/16x16/actions/redo.png", SubmitContent.this.table);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int result = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(SubmitContent.this), "<html><h3>Do you want to send these messages?</h3><font color='olive'><ul>" + ((SubmitTable)SubmitContent.this.table).getSelectionDescription() + "</ul></font></html>", SubmitContent.this.getClientContext().getTitle(), 0, 3);
            if (result == 0) {
                SubmitContent.this.getClientContext().displayContent(new SubmissionContent(SubmitContent.this.getClientContext(), SubmitContent.this, ((SubmitTable)SubmitContent.this.table).getEffectedMessages()));
            }
        }
    }

    class ValidateMessagesAction
    extends SelectionAction {
        ValidateMessagesAction() {
            super("Validate", "/img/16x16/validate.png", SubmitContent.this.table);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            SubmitContent.this.getClientContext().displayContent(new ValidationContent(SubmitContent.this.getClientContext(), SubmitContent.this, ((SubmitTable)SubmitContent.this.table).getEffectedMessages()));
        }
    }

    class ShowMessageDetailAction
    extends SelectionAction
    implements ListSelectionListener {
        ShowMessageDetailAction() {
            super("Open", "/img/16x16/mimetypes/dvi.png", SubmitContent.this.table);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            IPAYEMessage message = ((SubmitTable)SubmitContent.this.table).getPopupMessage();
            if (message != null) {
                SubmitContent.this.showDetail(message);
            }
        }

        @Override
        public boolean isEnabled() {
            return SubmitContent.this.table != null && ((SubmitTable)SubmitContent.this.table).getPopupMessage() != null;
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            this.setEnabled(((SubmitTable)SubmitContent.this.table).getPopupMessage() != null);
        }
    }

    class ReadPayrollAction
    extends AbstractAction {
        ReadPayrollAction() {
            super("Refresh", SwingHelper.imageIcon("/img/16x16/actions/reload.png"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SubmitContent.this.cmbMessageType.getMessageType() == null) {
                return;
            }
            IUser user = SubmitContent.this.getClientContext().getCurrentUser();
            if (user.getEmpRef().length == 0) {
                if (0 == JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(SubmitContent.this), "<html>There are no Employer References defined,<br>Do you want to add some now?</html>", SubmitContent.this.getClientContext().getTitle(), 0)) {
                    for (ClientContent content : SubmitContent.this.getClientContext().getMainOptions().getContent()) {
                        if (!(content instanceof SettingsContent)) continue;
                        SubmitContent.this.getClientContext().displayContent(content);
                    }
                } else {
                    return;
                }
            }
            SubmitContent.this.getClientContext().getSubmitter().submitWork((BackendWork)new ReadPayrollWork(SubmitContent.this.cmbTaxYear.getTaxYear(), SubmitContent.this.cmbMessageType.getMessageType(), SubmitContent.this.selEmpRefs.getEmpRefs()));
        }

        void considerEnabling(String[] refs) {
            this.setEnabled(refs.length > 0 || SubmitContent.this.getClientContext().getCurrentUser().getEmpRef().length == 0);
        }

        class ReadPayrollWork
        implements BackendWork {
            final int taxYear;
            final FormType type;
            final String[] empRefs;
            List<IPAYEMessage> messages;

            ReadPayrollWork(int taxYear, FormType type, String[] empRefs) {
                this.type = type;
                this.taxYear = taxYear;
                this.empRefs = empRefs;
                ReadPayrollAction.this.setEnabled(false);
                SingletonWaitingDialog.showDialog(SubmitContent.this.getClientContext(), new MultiRunPluginProgressModel(false), null);
            }

            public String getName() {
                return "Reading Payroll";
            }

            public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
                try {
                    this.messages = this.empRefs != null ? SubmitContent.this.getClientContext().getMailService().getPAYEMessages(this.type, this.taxYear, this.empRefs) : Collections.emptyList();
                }
                catch (IOException e) {
                    handle.setFailure((Throwable)e);
                }
                catch (PluginException e) {
                    handle.setFailure((Throwable)e);
                }
                catch (CancelException e) {
                    throw new CanceledException((Exception)e);
                }
            }

            public void invokeSwing(SwingOperationHandle handle) {
                SingletonWaitingDialog.hideDialog();
                if (handle.getFailure() == null) {
                    ((SubmitTable)SubmitContent.this.table).setMessages(this.type, this.messages);
                } else if (handle.getFailure() instanceof PayrollErrorException) {
                    SubmitContent.this.getClientContext().displayContent(new PayrollErrorsContent((PayrollErrorException)handle.getFailure(), SubmitContent.this.getClientContext(), SubmitContent.this));
                } else if (!(handle.getFailure() instanceof CanceledException)) {
                    FailureDialog.show(SubmitContent.this.getClientContext().getTitle(), "<b>Failed to extract messages from Payroll plugin</b>", handle.getFailure(), 500);
                    LogAPI.logSevere((Throwable)handle.getFailure());
                }
                ReadPayrollAction.this.setEnabled(true);
            }
        }
    }

    class DetailListener
    extends MouseAdapter {
        DetailListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            IPAYEMessage message;
            if (evt.getClickCount() > 1 && (message = ((SubmitTable)SubmitContent.this.table).getMessageAt(evt.getPoint())) != null) {
                SubmitContent.this.showDetail(message);
            }
        }
    }

    static class SubmitTable
    extends ContentTable {
        public SubmitTable(ClientContext cctx) {
            super(cctx, new TypedPAYEMessageTableModel(FormType.P14Part));
            this.installRenderers();
        }

        @Override
        public TypedPAYEMessageTableModel getModel() {
            return (TypedPAYEMessageTableModel)super.getModel();
        }

        void setMessages(final FormType type, final List<IPAYEMessage> data) {
            this.cctx.getSubmitter().submitWork(new BackendWork(){

                public String getName() {
                    return "Saving current columns";
                }

                public void invokeBackend(BackendOperationHandle handle) {
                    this.saveColumnModel();
                }

                public void invokeSwing(SwingOperationHandle handle) {
                    this.getModel().setType(type);
                    this.getModel().setMessages(data);
                }
            });
        }

        String getSelectionDescription() {
            int[] rows = this.getSelectedRows();
            StringBuffer result = new StringBuffer(1024);
            if (rows.length > 0) {
                for (int i = 0; i < rows.length; ++i) {
                    result.append("<li>").append(this.getRowDescription(rows[i])).append("</li>");
                }
            } else {
                int leadIndex = this.getSelectionModel().getLeadSelectionIndex();
                if (0 <= leadIndex && leadIndex < this.getRowCount()) {
                    result.append("<li>").append(this.getRowDescription(leadIndex)).append("</li>");
                }
            }
            return result.toString();
        }

        String getRowDescription(int row) {
            IPAYEMessage message = (IPAYEMessage)this.getModel().getRowValue(row);
            return message.getSubject();
        }

        IPAYEMessage getMessageAt(Point point) {
            int row = this.rowAtPoint(point);
            if (row >= 0 && row <= this.getRowCount()) {
                return (IPAYEMessage)this.getModel().getRowValue(row);
            }
            return null;
        }

        IPAYEMessage getPopupMessage() {
            Point point = this.getPopupPoint();
            int index = point != null ? this.rowAtPoint(point) : this.getSelectionModel().getLeadSelectionIndex();
            if (index >= 0 && index < this.getRowCount()) {
                return (IPAYEMessage)this.getModel().getRowValue(index);
            }
            return null;
        }

        List<IPAYEMessage> getEffectedMessages() {
            List<Object> result;
            int[] rows = this.getSelectedRows();
            if (rows.length > 0) {
                result = new ArrayList(rows.length);
                for (int i = 0; i < rows.length; ++i) {
                    result.add(this.getModel().getRowValue(rows[i]));
                }
            } else {
                int leadIndex = this.getSelectionModel().getLeadSelectionIndex();
                result = 0 <= leadIndex && leadIndex < this.getRowCount() ? Collections.singletonList(this.getModel().getRowValue(leadIndex)) : Collections.emptyList();
            }
            return result;
        }

        void hideRow(IPAYEMessage message) {
            this.getModel().hideRowsWithValues(message);
        }

        @Override
        public void createDefaultColumnsFromModel() {
            ContentTableColumnModel columnModel = this.load(this.getModel().getType().name(), this.getModel().getMapOfColumns());
            if (columnModel == null) {
                columnModel = new ContentTableColumnModel(this.getModel().getColumns());
            } else {
                List columns = Arrays.asList(this.getModel().getColumns());
                for (ContentTableColumn column : columnModel) {
                    column.setModelIndex(columns.indexOf(column.getTableModelColumn()));
                }
            }
            this.setColumnModel(columnModel);
            if (this.defaultRenderersByColumnClass != null) {
                this.installRenderers();
            }
        }

        @Override
        public void loadColumnModel() {
        }

        @Override
        public void saveColumnModel() {
            if (this.getModel().getType() != null) {
                this.save(this.getModel().getType().name(), this.getContentTableColumnModel());
            }
        }

        private void installRenderers() {
            HashSet<String> decimalColumns = new HashSet<String>(Arrays.asList("Total Contributions", "Total Tax", "Total NIC"));
            for (TableColumn column : Collections.list(this.getColumnModel().getColumns())) {
                TableCellRenderer cellRenderer = this.getDefaultRenderer(Object.class);
                if (decimalColumns.contains(column.getHeaderValue())) {
                    cellRenderer = new DecimalCellRenderer(cellRenderer);
                }
                column.setCellRenderer(new CellRenderer(cellRenderer));
            }
        }

        class CellRenderer
        implements TableCellRenderer {
            private final Icon MAIL_ICON = SwingHelper.imageIcon("/img/16x16/apps/mail_submit.png");
            private final TableCellRenderer renderer;

            CellRenderer(TableCellRenderer renderer) {
                this.renderer = renderer;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component comp;
                if (value == null) {
                    value = "";
                }
                if ((comp = this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    int alignment = ((Column)table.getColumnModel().getColumn(column).getIdentifier()).getAlign();
                    label.setHorizontalAlignment(alignment);
                    label.setBorder(BorderFactory.createCompoundBorder(label.getBorder(), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
                    if (column == 0) {
                        label.setIcon(this.MAIL_ICON);
                    } else {
                        label.setIcon(null);
                    }
                }
                return comp;
            }
        }

        class DecimalCellRenderer
        implements TableCellRenderer {
            final TableCellRenderer renderer;

            public DecimalCellRenderer(TableCellRenderer renderer) {
                this.renderer = renderer;
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value != null) {
                    value = decimalFormat.format(value);
                }
                return this.renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        }
    }

    class SouthPanel
    extends JPanel {
        SouthPanel() {
            super(new FlowLayout(1));
            this.add(new JButton(SubmitContent.this.sendMessagesAction));
        }
    }

    class TaxYearComboBoxModel
    implements ComboBoxModel,
    Runnable {
        private int range = 6;
        private int firstYear;
        private boolean running;
        private Integer selectedYear;
        private EventBroadcast<ListDataListener> listeners = EventBroadcastFactory.createEventBroadcast(ListDataListener.class);

        TaxYearComboBoxModel() {
            GregorianCalendar calendar = new GregorianCalendar();
            this.selectedYear = calendar.get(2) > 2 ? Integer.valueOf(calendar.get(1) + 1) : Integer.valueOf(calendar.get(1));
            this.firstYear = this.selectedYear - this.range;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            if (anItem == null && this.selectedYear == null || anItem.equals(this.selectedYear)) {
                return;
            }
            this.selectedYear = (Integer)anItem;
            ((ListDataListener)this.listeners.getListener()).contentsChanged(new ListDataEvent(this, 0, -1, -1));
            if (this.selectedYear - this.firstYear < 3 || this.firstYear + 2 * this.range - 1 - this.selectedYear < 3) {
                this.updateContentsLater();
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedYear;
        }

        @Override
        public int getSize() {
            return 2 * this.range;
        }

        @Override
        public Object getElementAt(int index) {
            return this.firstYear + index;
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.listeners.addListener((Object)l);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.listeners.removeListener((Object)l);
        }

        private void updateContentsLater() {
            if (!this.running) {
                this.running = true;
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            try {
                while (this.selectedYear - this.firstYear < 3) {
                    this.firstYear -= this.range;
                }
                while (this.firstYear + 2 * this.range - 1 - this.selectedYear < 3) {
                    this.firstYear += this.range;
                }
                ((ListDataListener)this.listeners.getListener()).contentsChanged(new ListDataEvent(this, 0, 0, this.getSize()));
            }
            finally {
                this.running = false;
            }
        }
    }

    class TaxYearComboBoxEditor
    extends BasicComboBoxEditor {
        private Object oldValue;

        TaxYearComboBoxEditor() {
            this.editor = new JTextField();
            this.editor.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }

        @Override
        public Object getItem() {
            String newValue = this.editor.getText();
            String[] numbers = newValue.split("\\D");
            if (numbers.length > 0 && numbers[0].length() > 0) {
                return new Integer(numbers[numbers.length - 1]);
            }
            return this.oldValue;
        }

        @Override
        public void setItem(Object anObject) {
            this.oldValue = anObject;
            Integer ival = (Integer)anObject;
            this.editor.setText(ival - 1 + " - " + ival);
        }
    }

    class TaxYearComboBoxRenderer
    extends DefaultListCellRenderer {
        TaxYearComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Integer ival = (Integer)value;
            value = ival - 1 + " - " + ival;
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }

    class TaxYearComboBox
    extends JComboBox {
        TaxYearComboBox() {
            super(new TaxYearComboBoxModel());
            this.setEditable(true);
            this.setRenderer(new TaxYearComboBoxRenderer());
            this.setEditor(new TaxYearComboBoxEditor());
            this.setMaximumSize(this.getPreferredSize());
            this.getModel().addListDataListener(new ListDataListener(){

                @Override
                public void contentsChanged(ListDataEvent evt) {
                    if (evt.getIndex0() == 0 && evt.getIndex1() == TaxYearComboBox.this.getModel().getSize()) {
                        TaxYearComboBox.this.fireItemStateChanged(new ItemEvent(TaxYearComboBox.this, 701, TaxYearComboBox.this.getModel().getSelectedItem(), 1));
                    }
                }

                @Override
                public void intervalAdded(ListDataEvent e) {
                }

                @Override
                public void intervalRemoved(ListDataEvent e) {
                }
            });
        }

        int getTaxYear() {
            return (Integer)this.getModel().getSelectedItem();
        }
    }

    class MessageTypeComboBox
    extends JComboBox
    implements BackendWork {
        MessageTypeComboBox() {
            super(new Object[0]);
            this.setRenderer(new FormTypeRenderer(this.getRenderer()));
            this.updateModel();
        }

        void updateModel() {
            SubmitContent.this.getClientContext().getSubmitter().submitWork((BackendWork)this);
        }

        @Override
        public Dimension getMaximumSize() {
            return super.getPreferredSize();
        }

        FormType getMessageType() {
            return (FormType)((Object)this.getSelectedItem());
        }

        public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
            Vector<FormType> formTypes = new Vector<FormType>(Arrays.asList(FormType.values()));
            IPayrollPlugin plugin = SubmitContent.this.getClientContext().getCurrentUser().getPayrollPlugin();
            Iterator<FormType> it = formTypes.iterator();
            while (it.hasNext()) {
                FormType formType = it.next();
                if (plugin.isRetrievable(formType)) continue;
                it.remove();
            }
            handle.setResult(formTypes);
        }

        public void invokeSwing(SwingOperationHandle handle) {
            Object selection = this.getModel().getSelectedItem();
            Vector formTypes = (Vector)handle.getResult();
            DefaultComboBoxModel newModel = new DefaultComboBoxModel(formTypes);
            if (selection != null) {
                newModel.setSelectedItem(selection);
            }
            this.setModel(newModel);
        }

        class FormTypeRenderer
        implements ListCellRenderer {
            ListCellRenderer renderer;

            FormTypeRenderer(ListCellRenderer renderer) {
                this.renderer = renderer;
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                value = String.valueOf(value);
                return this.renderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        }
    }

    class PluginTypeComboBox
    extends JComboBox
    implements BackendWork {
        PluginTypeComboBox() {
            super(PluginType.values());
            this.setName("Setting preferred plugin");
            this.setSelectedItem((Object)SubmitContent.this.getClientContext().getCurrentUser().getPluginType());
            this.setMaximumSize(this.getPreferredSize());
        }

        @Override
        public void contentsChanged(ListDataEvent evt) {
            super.contentsChanged(evt);
            if (evt.getIndex0() == -1 && evt.getIndex1() == -1) {
                SubmitContent.this.getClientContext().getCurrentUser().setPluginType((PluginType)((Object)this.getSelectedItem()));
                SubmitContent.this.getClientContext().getSubmitter().submitWork((BackendWork)this);
                SubmitContent.this.cmbMessageType.updateModel();
            }
        }

        public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
            SubmitContent.this.getClientContext().getStatusBar().setInterrupter(new StorageInterrupter(SubmitContent.this.getClientContext().getStorageFactory()));
            try {
                SubmitContent.this.getClientContext().getUserManager().saveUser(SubmitContent.this.getClientContext().getCurrentUser());
            }
            catch (IOException e) {
                LogAPI.logSevere((Throwable)e);
            }
            catch (CancelException e) {
                throw new CanceledException((Exception)e);
            }
            finally {
                SubmitContent.this.getClientContext().getStatusBar().setInterrupter(null);
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
        }
    }
}

