/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content;

import com.selima.fbi.Folder;
import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.SelectionAction;
import com.selima.fbi.ui.content.AbstractClientContent;
import com.selima.fbi.ui.content.MessageBoxContent;
import com.selima.fbi.ui.content.detail.SentboxDetailContent;
import com.selima.fbi.ui.content.mboxtable.SentMessageTable;
import com.selima.fbi.ui.content.result.HistoryContent;
import java.awt.event.ActionEvent;

public class SentboxContent
extends MessageBoxContent<IPAYEMessage> {
    public SentboxContent(MailServiceClientContext cctx) {
        this(cctx, new SentMessageTable(cctx));
    }

    private SentboxContent(MailServiceClientContext cctx, SentMessageTable table) {
        super(cctx, table, Folder.SENT, "/img/32x32/apps/mail_sent4.png", "Opening Sent Folder", false);
        this.toolBar.addAfter("Save", new SubmissionRecordAction());
    }

    @Override
    public String getContentName() {
        return "Sent";
    }

    @Override
    public String getDescription() {
        return "Submitted messages including Submission Log";
    }

    @Override
    public String getHelpTopic() {
        return "content.context-help.sent";
    }

    @Override
    protected ClientContent createDetailContent(IPAYEMessage message) {
        return new SentboxDetailContent(this, message);
    }

    class SubmissionRecordAction
    extends SelectionAction {
        SubmissionRecordAction() {
            super("Submission Record", "/img/16x16/apps/mail_submit.png", SentboxContent.this.table);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SentboxContent.this.getClientContext().displayContent(new HistoryContent((AbstractClientContent)SentboxContent.this, SentboxContent.this.getSelection()));
        }
    }
}

