/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content;

import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.AbstractSaveAction;
import com.selima.fbi.ui.common.FBIFileChooser;
import com.selima.fbi.ui.common.FormatDirectoryChooser;
import com.selima.fbi.ui.common.FormatFileChooser;
import com.selima.fbi.ui.common.waitdlg.BackendWorkInterrupter;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.HTMLSaveModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.common.waitdlg.XMLSaveModel;
import com.selima.fbi.ui.export.HTMLExporter;
import com.selima.fbi.ui.export.XMLExporter;
import com.selima.fbi.util.IOUtil;
import com.selima.fbi.webserver.WebServerException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.CanceledException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

abstract class MultiSaveAction
extends AbstractSaveAction
implements ListSelectionListener {
    private JTable table;

    MultiSaveAction(MailServiceClientContext clientContext, JTable table) {
        super(clientContext);
        this.table = table;
        this.setEnabled(!table.getSelectionModel().isSelectionEmpty());
        table.getSelectionModel().addListSelectionListener(this);
    }

    protected abstract IMailMessage getMessage(int var1);

    @Override
    protected FBIFileChooser createFileChooser() throws WebServerException, IOException {
        int messageCount = this.table.getSelectedRowCount();
        if (messageCount == 1) {
            FormatFileChooser fileChooser = new FormatFileChooser();
            IMailMessage message = this.getMessage(this.table.getSelectedRow());
            int pageCount = this.clientContext().getWebServer().pageCount(message);
            fileChooser.setManyHtmlPages(pageCount > 1);
            fileChooser.setProposedBaseName(this.baseName(message));
            return fileChooser;
        }
        return new FormatDirectoryChooser();
    }

    @Override
    protected BackendWorkInterrupter showProgressBar(FBIFileChooser fileChooser) {
        if (this.table.getSelectedRowCount() > 1 || fileChooser.isHtml()) {
            BasicInterrupter interrupter = new BasicInterrupter();
            SingletonWaitingDialog.showDialog(this.clientContext(), fileChooser.isXml() ? new XMLSaveModel(this.getMessages()) : new HTMLSaveModel(this.getMessages()), interrupter);
            return interrupter;
        }
        return null;
    }

    @Override
    protected void hideProgressBar() {
        if (SingletonWaitingDialog.isVisible()) {
            SingletonWaitingDialog.hideDialog();
        }
    }

    @Override
    protected void performSave(FBIFileChooser fileChooser, BackendOperationHandle handle) throws IOException, WebServerException, CanceledException {
        boolean xml = fileChooser.isXml();
        File file = fileChooser.getSelectedFile();
        if (fileChooser instanceof FormatDirectoryChooser) {
            this.saveFiles(file, xml, handle);
        } else {
            if (!file.isDirectory()) {
                xml = this.preferredXml(file, xml);
                file = this.preferredFile(file, xml);
            } else {
                file = this.preferredFile(new File(file, this.baseName(this.getMessage(this.table.getSelectedRow()))), xml);
            }
            this.saveFile(file, xml, handle);
        }
    }

    private List<IMailMessage> getMessages() {
        int[] rows = this.table.getSelectedRows();
        ArrayList<IMailMessage> result = new ArrayList<IMailMessage>(rows.length);
        for (int row : rows) {
            result.add(this.getMessage(row));
        }
        return result;
    }

    private void saveFile(File file, boolean xml, BackendOperationHandle handle) throws IOException, WebServerException, CanceledException {
        IMailMessage message = this.getMessage(this.table.getSelectedRow());
        if (xml) {
            XMLExporter xmlExporter = new XMLExporter(this.clientContext().getStatusBar());
            XMLSaveModel xmlProgress = (XMLSaveModel)SingletonWaitingDialog.getProgressModel();
            if (xmlProgress != null) {
                xmlExporter.addListener(xmlProgress);
            }
            xmlExporter.export(message, file, handle);
        } else {
            HTMLExporter htmlExporter = new HTMLExporter(this.clientContext().getWebServer(), this.clientContext().getStatusBar());
            HTMLSaveModel htmlProgress = (HTMLSaveModel)SingletonWaitingDialog.getProgressModel();
            if (htmlProgress != null) {
                htmlExporter.addListener(htmlProgress);
            }
            htmlExporter.export(message, (String)null, file, handle);
        }
    }

    private void saveFiles(File dir, boolean xml, BackendOperationHandle handle) throws IOException, WebServerException, CanceledException {
        if (!dir.exists()) {
            dir.mkdir();
        }
        List<IMailMessage> messages = this.getMessages();
        HashSet<File> savedFiles = new HashSet<File>(messages.size());
        HTMLExporter htmlExporter = null;
        XMLExporter xmlExporter = null;
        for (IMailMessage message : messages) {
            handle.checkCancelRequest();
            String baseName = this.baseName(message);
            String extension = xml ? ".xml" : ".html";
            File saveFile = new File(dir, baseName + extension);
            saveFile = IOUtil.uniqueFile(saveFile, savedFiles);
            this.clientContext().getStatusBar().displayMessage("Saving " + saveFile.getPath());
            if (xml) {
                if (xmlExporter == null) {
                    xmlExporter = new XMLExporter(this.clientContext().getStatusBar());
                    XMLSaveModel xmlProgress = (XMLSaveModel)SingletonWaitingDialog.getProgressModel();
                    if (xmlProgress != null) {
                        xmlExporter.addListener(xmlProgress);
                    }
                }
                xmlExporter.export(message, saveFile, handle);
            } else {
                if (htmlExporter == null) {
                    htmlExporter = new HTMLExporter(this.clientContext().getWebServer(), this.clientContext().getStatusBar());
                    HTMLSaveModel htmlProgress = (HTMLSaveModel)SingletonWaitingDialog.getProgressModel();
                    if (htmlProgress != null) {
                        htmlExporter.addListener(htmlProgress);
                    }
                }
                htmlExporter.export(message, (String)null, saveFile, handle);
            }
            savedFiles.add(saveFile);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        ListSelectionModel model = (ListSelectionModel)evt.getSource();
        this.setEnabled(!model.isSelectionEmpty());
    }
}

