/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content;

import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IPayrollCheckedMessage;
import com.selima.fbi.plugin.PluginChainableException;
import com.selima.fbi.plugin.PluginException;
import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.SelectionAction;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.MailServiceInterrupter;
import com.selima.fbi.ui.common.waitdlg.MultiRunPluginProgressModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.content.DPSMessageBoxContent;
import com.selima.fbi.ui.content.MessageBoxContent;
import com.selima.fbi.ui.content.detail.TransferDetailContent;
import com.selima.fbi.ui.content.mboxtable.MailMessageTable;
import com.selima.fbi.ui.content.mboxtable.MailMessageTableModel;
import com.selima.fbi.ui.content.mboxtable.PayrollCheckedMessageTable;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;

public abstract class MessageTransferContent
extends DPSMessageBoxContent {
    PayrollCheckProcess payrollCheckProcess = new PayrollCheckProcess();

    public MessageTransferContent(MailServiceClientContext cctx, Folder folder, String icon, String starttext, boolean searchRefs) {
        super(cctx, new PayrollCheckedMessageTable(cctx), folder, icon, starttext, searchRefs);
        this.toolBar.addAfter("Save", new TransferAction()).replace("Delete", new SaferDeleteAction());
    }

    @Override
    public BackendWork getClosingWork() {
        this.payrollCheckProcess.stopChecks();
        return super.getClosingWork();
    }

    @Override
    public BackendWork getOpeningWork() {
        final BackendWork originalWork = super.getOpeningWork();
        return new BackendWork(){

            public String getName() {
                return originalWork.getName();
            }

            public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
                originalWork.invokeBackend(handle);
            }

            public void invokeSwing(SwingOperationHandle handle) {
                try {
                    originalWork.invokeSwing(handle);
                }
                finally {
                    MessageTransferContent.this.payrollCheckProcess.continueChecks();
                }
            }
        };
    }

    @Override
    protected StringBuilder format(List<IDPSMessage> selection, StringBuilder text) {
        text.append("<UL style='margin-left:20px;margin-right:20px;width:320px'>");
        int limit = 5;
        ListIterator<IDPSMessage> it = selection.listIterator();
        while (it.hasNext()) {
            IDPSMessage message = it.next();
            if (it.previousIndex() < limit) {
                text.append("<LI STYLE='white-space:nowrap'>");
                if (message.isTransferrable()) {
                    text.append("<B>");
                }
                text.append(message.getStoreId()).append(' ').append("<FONT COLOR='olive'>").append(message.getSubject()).append("</FONT>");
                if (message.isTransferrable()) {
                    text.append("</B>");
                }
                text.append("</LI>");
                continue;
            }
            if (it.previousIndex() != limit) continue;
            text.append("<LI>... ").append(selection.size() - limit).append(" more</LI>");
            break;
        }
        text.append("</UL>");
        return text;
    }

    void startChecks(IDPSMessage fromMessage) {
        this.payrollCheckProcess.startChecks(fromMessage);
    }

    @Override
    protected ClientContent createDetailContent(IDPSMessage message) {
        return new TransferDetailContent<IDPSMessage>(this.getClientContext(), this, message);
    }

    class PayrollCheckProcess {
        List<IDPSMessage> messages;
        SwingOperationHandle currentHandle;
        IDPSMessage stoppedMessage;
        boolean stopped;

        PayrollCheckProcess() {
        }

        void startChecks(IDPSMessage fromMessage) {
            this.stopped = false;
            this.currentHandle = null;
            this.stoppedMessage = null;
            this.checkNext(fromMessage, this.currentHandle, new HashSet<String>());
        }

        void continueChecks() {
            this.stopped = false;
            IDPSMessage fromMessage = this.stoppedMessage;
            this.stoppedMessage = null;
            if (fromMessage == null && ((MailMessageTable)MessageTransferContent.this.table).getRowCount() > 0) {
                fromMessage = (IDPSMessage)((MailMessageTable)MessageTransferContent.this.table).getModel().getRowValue(0);
            }
            if (fromMessage != null) {
                this.checkNext(fromMessage, this.currentHandle, new HashSet<String>());
            }
        }

        void stopChecks() {
            this.stopped = true;
            if (this.currentHandle != null && !this.currentHandle.isFinished()) {
                this.runInterruptionTimer(this.currentHandle);
            }
        }

        private void runInterruptionTimer(final SwingOperationHandle handle) {
            Timer timer = new Timer(5000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!handle.isFinished()) {
                        MessageTransferContent.this.getClientContext().getMailService().cancel();
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        private void checkNext(IDPSMessage fromMessage, SwingOperationHandle handle, Set<String> taxReferences) {
            int index;
            if (handle != this.currentHandle) {
                return;
            }
            if (this.stopped) {
                this.stoppedMessage = fromMessage;
                return;
            }
            this.currentHandle = null;
            this.messages = ((MailMessageTableModel)((MailMessageTable)MessageTransferContent.this.table).getModel()).getMessages();
            int firstIndex = this.messages.indexOf(fromMessage);
            if (firstIndex == -1) {
                ++firstIndex;
            }
            for (index = firstIndex; index < this.messages.size(); ++index) {
                if (!this.launchedCheck(this.messages.get(index), taxReferences)) continue;
                return;
            }
            for (index = 0; index < firstIndex; ++index) {
                if (!this.launchedCheck(this.messages.get(index), taxReferences)) continue;
                return;
            }
        }

        private boolean launchedCheck(IDPSMessage message, Set<String> taxReferences) {
            IPayrollCheckedMessage checkedMessage;
            if (message instanceof IPayrollCheckedMessage && !(checkedMessage = (IPayrollCheckedMessage)message).isUptodate()) {
                if (this.currentHandle != null && !this.currentHandle.isFinished()) {
                    this.runInterruptionTimer(this.currentHandle);
                }
                this.currentHandle = MessageTransferContent.this.getClientContext().getSubmitter().submitWork((BackendWork)new PayrollCheckWork(checkedMessage, taxReferences));
                return true;
            }
            return false;
        }

        private class PayrollCheckWork
        implements BackendWork {
            final IPayrollCheckedMessage message;
            final Set<String> taxReferences;

            PayrollCheckWork(IPayrollCheckedMessage message, Set<String> taxReferences) {
                this.taxReferences = taxReferences;
                this.message = message;
            }

            public String getName() {
                return "Checking " + this.message.getSubject();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
                MessageTransferContent.this.getClientContext().getStatusBar().setInterrupter(new MailServiceInterrupter(MessageTransferContent.this.getClientContext().getMailService()));
                String taxRef = this.message.getEmpRef();
                try {
                    this.message.checkInPayroll(!this.taxReferences.contains(taxRef));
                }
                catch (CancelException e) {
                    LogAPI.logSevere((Throwable)e);
                }
                catch (PluginException e) {
                    LogAPI.logSevere((Throwable)e);
                    handle.setFailure((Throwable)e);
                }
                finally {
                    this.taxReferences.add(taxRef);
                    MessageTransferContent.this.getClientContext().getStatusBar().setInterrupter(null);
                }
            }

            public void invokeSwing(SwingOperationHandle handle) {
                if (handle.getFailure() != null) {
                    FailureDialog.show(MessageTransferContent.this.getClientContext().getTitle(), "Payroll Check Failed", handle.getFailure(), 400);
                } else {
                    int index = ((MailMessageTableModel)((MailMessageTable)MessageTransferContent.this.table).getModel()).getMessages().indexOf(this.message);
                    if (index != -1) {
                        ((MailMessageTable)MessageTransferContent.this.table).getModel().fireTableRowsUpdated(index, index);
                    }
                    String text = "Checked " + this.message.getSubject() + ": " + (this.message.getPayrollWarningMessage() != null ? this.message.getPayrollWarningMessage() : "OK");
                    MessageTransferContent.this.getClientContext().getStatusBar().displayMessage(text);
                    PayrollCheckProcess.this.checkNext(this.message, handle, this.taxReferences);
                }
            }
        }
    }

    class TransferAction
    extends SelectionAction {
        TransferAction() {
            super("Transfer", "/img/16x16/actions/mail_transfer.png", MessageTransferContent.this.table);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            List<IDPSMessage> selection = MessageTransferContent.this.getSelection();
            List messages = ((MailMessageTableModel)((MailMessageTable)MessageTransferContent.this.table).getModel()).getMessages();
            int index = messages.indexOf(selection.get(selection.size() - 1)) + 1;
            TransferWork work = new TransferWork(selection, (IDPSMessage)messages.get(index % messages.size()));
            work.setTaskHandle(MessageTransferContent.this.getClientContext().getSubmitter().submitWork((BackendWork)work));
        }

        private void hideMessageEDT(final IDPSMessage message) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageTransferContent.this.hideMessage(message);
                }
            });
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            this.considerEnabling();
        }

        void considerEnabling() {
            for (IDPSMessage message : MessageTransferContent.this.getSelection()) {
                if (!message.isTransferrable()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        class TransferWork
        extends BasicInterrupter
        implements BackendWork {
            final String name;
            final List<IDPSMessage> messages;
            final IDPSMessage messageToCheck;

            TransferWork(List<IDPSMessage> messages, IDPSMessage messageToCheck) {
                this.messages = messages;
                this.messageToCheck = messageToCheck;
                this.name = "Transferring " + messages.size() + " message" + (messages.size() > 1 ? "s" : "") + " to payroll";
                MessageTransferContent.this.getClientContext().getStatusBar().displayMessage(this.name);
                TransferAction.this.setEnabled(false);
                MultiRunPluginProgressModel progressModel = new MultiRunPluginProgressModel(true);
                progressModel.registerNumOfRuns(messages.size());
                SingletonWaitingDialog.showDialog(MessageTransferContent.this.getClientContext(), progressModel, this);
            }

            public String getName() {
                return this.name;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
                handle.checkCancelRequest();
                PluginChainableException errors = null;
                try {
                    HashSet<String> taxReferences = new HashSet<String>();
                    Iterator<IDPSMessage> it = this.messages.iterator();
                    while (it.hasNext()) {
                        handle.checkCancelRequest();
                        IDPSMessage message = it.next();
                        if (!message.isTransferrable()) continue;
                        String taxReference = message.getEmpRef();
                        try {
                            message.transfer(!taxReferences.contains(taxReference));
                            TransferAction.this.hideMessageEDT(message);
                            it.remove();
                        }
                        catch (PluginChainableException e) {
                            if (errors == null) {
                                errors = e;
                                continue;
                            }
                            errors.chain(e);
                        }
                        finally {
                            taxReferences.add(taxReference);
                        }
                    }
                    if (errors != null) {
                        handle.setFailure(errors);
                    }
                }
                catch (CancelException e) {
                    if (errors != null) {
                        handle.setFailure(errors);
                    }
                    throw new CanceledException((Exception)e);
                }
                catch (PluginException e) {
                    handle.setFailure((Throwable)e);
                }
                catch (IOException e) {
                    handle.setFailure((Throwable)e);
                }
            }

            public void invokeSwing(SwingOperationHandle handle) {
                SingletonWaitingDialog.hideDialog();
                if (handle.getFailure() == null) {
                    MessageTransferContent.this.getClientContext().getStatusBar().displayMessage("Transfer accomplished successfully.");
                } else if (!(handle.getFailure() instanceof CanceledException)) {
                    String message;
                    if (handle.getFailure() instanceof PluginChainableException) {
                        PluginChainableException pluginException = (PluginChainableException)handle.getFailure();
                        message = "<html>Failed to transfer <b>" + pluginException.getNumOfErrors() + " messages</b> into payroll.</html>";
                    } else {
                        message = "<html><b>Unexpected failure transferring messages to payroll.</b></html>";
                    }
                    FailureDialog.show(MessageTransferContent.this.getClientContext().getTitle(), message, handle.getFailure(), 400);
                    LogAPI.logSevere((Throwable)handle.getFailure());
                }
                ((MailMessageTable)MessageTransferContent.this.table).repaint();
                TransferAction.this.considerEnabling();
                MessageTransferContent.this.startChecks(this.messageToCheck);
            }
        }
    }

    class SaferDeleteAction
    extends MessageBoxContent.DeleteAction {
        SaferDeleteAction() {
        }

        StringBuilder buildWarning(List<IDPSMessage> selection) {
            StringBuilder stringBuilder = super.buildWarning(selection);
            int transferableCount = 0;
            for (IDPSMessage message : selection) {
                if (!message.isTransferrable()) continue;
                ++transferableCount;
            }
            if (transferableCount > 0) {
                stringBuilder.setLength(stringBuilder.length() - "</HTML>".length());
                if (transferableCount > 1) {
                    stringBuilder.append("<P STYLE='width:320px'><B>There are " + transferableCount + " transferable messages included, that if deleted would never reach payroll.</B></P></HTML>");
                } else if (selection.size() > 1) {
                    stringBuilder.append("<P STYLE='width:320px'><B>There is a  transferable message included, that if deleted would never reach payroll.</B></P></HTML>");
                } else {
                    stringBuilder.append("<P STYLE='width:320px'><B>The message  is transferable and if deleted would never reach payroll.</B></P></HTML>");
                }
            }
            return stringBuilder;
        }
    }
}

