/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content;

import com.selima.fbi.CancelException;
import com.selima.fbi.Folder;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.SelectionAction;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.ToolBar;
import com.selima.fbi.ui.common.waitdlg.MailServiceInterrupter;
import com.selima.fbi.ui.content.AbstractClientContent;
import com.selima.fbi.ui.content.AbstractTableContent;
import com.selima.fbi.ui.content.MultiSaveAction;
import com.selima.fbi.ui.content.empsel.EmpSelectionBox;
import com.selima.fbi.ui.content.mboxtable.MailMessageTable;
import com.selima.fbi.ui.content.mboxtable.MailMessageTableModel;
import com.selima.fbi.ui.content.settings.SettingsContent;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.fbi.user.IUser;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class MessageBoxContent<MessageType extends IMailMessage>
extends AbstractTableContent<MailMessageTable<MessageType>> {
    protected EmpSelectionBox selectionBox;
    protected ToolBar toolBar;
    protected Folder folder;

    protected MessageBoxContent(MailServiceClientContext cctx, final MailMessageTable<MessageType> table, Folder folder, String icon, String openingText, boolean allowRefSearch) {
        super(cctx, icon, openingText, table);
        this.folder = folder;
        table.addMouseListener(new DetailMouseListener());
        Object[] objectArray = new Object[6];
        this.selectionBox = new EmpSelectionBox(this.getClientContext(), allowRefSearch);
        objectArray[0] = this.selectionBox;
        objectArray[1] = Box.createHorizontalStrut(10);
        objectArray[2] = new BewareEmptyRefreshAction(new RefreshAction());
        objectArray[3] = new DetailAction();
        objectArray[4] = new SaveAction();
        objectArray[5] = new DeleteAction();
        this.toolBar = new ToolBar(objectArray);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Action action : MessageBoxContent.this.toolBar.getActions()) {
                    table.getPopupMenu().add(action);
                }
            }
        });
    }

    protected abstract ClientContent createDetailContent(MessageType var1);

    public Folder getFolder() {
        return this.folder;
    }

    @Override
    public ToolBar getToolBar() {
        return this.toolBar;
    }

    @Override
    public BackendWork getOpeningWork() {
        return new ReopenWork();
    }

    public void hideMessages(List<MessageType> messages) {
        ((MailMessageTableModel)((MailMessageTable)this.table).getModel()).hideRows(messages);
    }

    public void hideMessage(MessageType message) {
        ((MailMessageTableModel)((MailMessageTable)this.table).getModel()).hideRowsWithValues(message);
    }

    protected StringBuilder format(List<MessageType> selection, StringBuilder text) {
        text.append("<UL style='margin-left:20px;margin-right:20px;width:320px'>");
        ListIterator<MessageType> it = selection.listIterator();
        while (it.hasNext()) {
            IMailMessage message = (IMailMessage)it.next();
            if (it.previousIndex() < 6) {
                text.append("<LI STYLE='white-space:nowrap'>").append(message.getStoreId()).append(" <FONT COLOR='olive'>").append(message.getSubject()).append("</FONT></LI>");
                continue;
            }
            if (it.previousIndex() != 6) continue;
            text.append("<LI>... ").append(selection.size() - 6).append(" more</LI>");
            break;
        }
        text.append("</UL>");
        return text;
    }

    protected void displayDetailContent(MessageType message) {
        if (message != null) {
            this.getClientContext().displayContent(this.createDetailContent(message));
        }
    }

    protected MessageType getPopupMessage() {
        Point point = ((MailMessageTable)this.table).getPopupPoint();
        int index = point != null ? ((MailMessageTable)this.table).rowAtPoint(point) : ((MailMessageTable)this.table).getSelectionModel().getLeadSelectionIndex();
        if (index >= 0 && index < ((MailMessageTable)this.table).getRowCount()) {
            return (MessageType)((IMailMessage)((MailMessageTable)this.table).getModel().getRowValue(index));
        }
        return null;
    }

    protected List<MessageType> getSelection() {
        int[] rows = ((MailMessageTable)this.table).getSelectedRows();
        ArrayList result = new ArrayList(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            result.add(((MailMessageTable)this.table).getModel().getRowValue(rows[i]));
        }
        return result;
    }

    protected class DetailMouseListener
    extends MouseAdapter {
        protected DetailMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int row;
            if (evt.getClickCount() > 1 && (row = ((MailMessageTable)MessageBoxContent.this.table).rowAtPoint(evt.getPoint())) >= 0 && row < ((MailMessageTable)MessageBoxContent.this.table).getRowCount()) {
                MessageBoxContent.this.displayDetailContent((IMailMessage)((MailMessageTableModel)((MailMessageTable)MessageBoxContent.this.table).getModel()).getRow(row).getRowData());
            }
        }
    }

    class DeleteAction
    extends SelectionAction {
        DeleteAction() {
            super("Delete", "/img/16x16/actions/mail_delete.png", MessageBoxContent.this.table);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            List selection = MessageBoxContent.this.getSelection();
            StringBuilder text = this.buildWarning(selection);
            if (0 == JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(MessageBoxContent.this), text, MessageBoxContent.this.getClientContext().getTitle(), 0, 3)) {
                MessageBoxContent.this.getClientContext().getSubmitter().submitWork((BackendWork)new DeleteWork(selection));
            }
        }

        StringBuilder buildWarning(List<MessageType> selection) {
            StringBuilder text = new StringBuilder(selection.size() * 32);
            if (selection.size() > 1) {
                text.append("<html>Following messages will be deleted:");
            } else {
                text.append("<html>Following message will be deleted:");
            }
            MessageBoxContent.this.format(selection, text).append("</html>");
            return text;
        }

        private final class DeleteWork
        implements BackendWork {
            private final List<MessageType> selection;

            private DeleteWork(List<MessageType> selection) {
                this.selection = selection;
            }

            public String getName() {
                return "Deleting messages";
            }

            public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
                MessageBoxContent.this.getClientContext().getStatusBar().setInterrupter(new MailServiceInterrupter(MessageBoxContent.this.getClientContext().getMailService()));
                try {
                    String[] ids = new String[this.selection.size()];
                    ListIterator it = this.selection.listIterator();
                    while (it.hasNext()) {
                        ids[it.nextIndex()] = ((IMailMessage)it.next()).getStoreId();
                    }
                    MessageBoxContent.this.getClientContext().getMailService().deleteMessages(MessageBoxContent.this.folder, (ArrayList)this.selection);
                }
                catch (IOException e) {
                    handle.setFailure((Throwable)e);
                }
                catch (CancelException e) {
                    throw new CanceledException((Exception)e);
                }
                finally {
                    MessageBoxContent.this.getClientContext().getStatusBar().setInterrupter(null);
                }
            }

            public void invokeSwing(SwingOperationHandle handle) {
                if (handle.getFailure() != null && !(handle.getFailure() instanceof CanceledException)) {
                    FailureDialog.show(MessageBoxContent.this.getClientContext().getTitle(), "<b>Failed to delete messages</b>", handle.getFailure());
                    LogAPI.logSevere((Throwable)handle.getFailure());
                } else {
                    MessageBoxContent.this.hideMessages(this.selection);
                }
            }
        }
    }

    class SaveAction
    extends MultiSaveAction {
        SaveAction() {
            super(MessageBoxContent.this.getClientContext(), MessageBoxContent.this.table);
        }

        @Override
        protected IMailMessage getMessage(int index) {
            return (IMailMessage)((MailMessageTable)MessageBoxContent.this.table).getModel().getRowValue(index);
        }
    }

    class DetailAction
    extends SingleMessageAction {
        DetailAction() {
            super("Open", SwingHelper.imageIcon("/img/16x16/mimetypes/dvi.png"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MessageBoxContent.this.displayDetailContent(MessageBoxContent.this.getPopupMessage());
        }
    }

    protected abstract class SingleMessageAction
    extends AbstractAction
    implements ListSelectionListener {
        protected SingleMessageAction(String prefix, Icon icon) {
            super(prefix, icon);
            ((MailMessageTable)MessageBoxContent.this.table).getSelectionModel().addListSelectionListener(this);
            this.adaptToAnchor();
        }

        @Override
        public boolean isEnabled() {
            return MessageBoxContent.this.getPopupMessage() != null;
        }

        private void adaptToAnchor() {
            this.setEnabled(MessageBoxContent.this.getPopupMessage() != null);
        }

        @Override
        public void valueChanged(ListSelectionEvent evt) {
            this.adaptToAnchor();
        }
    }

    protected class BewareEmptyRefreshAction
    implements Action {
        Action wrapped;

        BewareEmptyRefreshAction(Action action) {
            this.wrapped = action;
        }

        @Override
        public Object getValue(String key) {
            return this.wrapped.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            this.wrapped.putValue(key, value);
        }

        @Override
        public void setEnabled(boolean b) {
            this.wrapped.setEnabled(b);
        }

        @Override
        public boolean isEnabled() {
            return this.wrapped.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.wrapped.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.wrapped.removePropertyChangeListener(listener);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            IUser user = MessageBoxContent.this.getClientContext().getCurrentUser();
            if (!MessageBoxContent.this.selectionBox.isActiveSearch() && user.getEmpRef().length == 0) {
                if (0 == JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor((Component)evt.getSource()), "<html>There are no Employer References defined,<br>Do you want to add some now?</html>", MessageBoxContent.this.getClientContext().getTitle(), 0)) {
                    for (ClientContent content : MessageBoxContent.this.getClientContext().getMainOptions().getContent()) {
                        if (!(content instanceof SettingsContent)) continue;
                        MessageBoxContent.this.getClientContext().displayContent(content);
                    }
                }
            } else {
                this.wrapped.actionPerformed(evt);
            }
        }
    }

    protected class RefreshAction
    extends AbstractAction {
        RefreshAction() {
            super("Refresh", SwingHelper.imageIcon("/img/16x16/actions/reload.png"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            MessageBoxContent.this.getClientContext().getSubmitter().submitWork((BackendWork)new DownloadWork());
        }
    }

    protected class ReopenWork
    implements BackendWork {
        protected ReopenWork() {
        }

        public void invokeSwing(SwingOperationHandle handle) {
        }

        public void invokeBackend(BackendOperationHandle handle) {
        }

        public String getName() {
            return "Openning " + (Object)((Object)MessageBoxContent.this.folder);
        }
    }

    protected class DownloadWork
    extends AbstractClientContent.OpeningWork {
        protected DownloadWork() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
            MessageBoxContent.this.getClientContext().getStatusBar().setInterrupter(new MailServiceInterrupter(MessageBoxContent.this.getClientContext().getMailService()));
            try {
                String[] empRefs;
                List<IMailMessage> list = MessageBoxContent.this.selectionBox.isActiveSearch() ? MessageBoxContent.this.getClientContext().getMailService().getMessages(MessageBoxContent.this.folder, new String[0]) : ((empRefs = MessageBoxContent.this.selectionBox.getEmpRefs()).length > 0 ? MessageBoxContent.this.getClientContext().getMailService().getMessages(MessageBoxContent.this.folder, empRefs) : new ArrayList<IMailMessage>());
                handle.setResult(list);
            }
            catch (CancelException e) {
                throw new CanceledException((Exception)e);
            }
            catch (DPSException e) {
                handle.setFailure((Throwable)e);
            }
            catch (RemoteException e) {
                handle.setFailure((Throwable)e);
            }
            catch (IOException e) {
                handle.setFailure((Throwable)e);
            }
            finally {
                MessageBoxContent.this.getClientContext().getStatusBar().setInterrupter(null);
            }
        }

        @Override
        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getFailure() == null) {
                ((MailMessageTable)MessageBoxContent.this.table).setMessages((List)handle.getResult());
            } else if (!(handle.getFailure() instanceof CanceledException)) {
                FailureDialog.show(MessageBoxContent.this.getClientContext().getTitle(), "<b>Failed to load messages</b>", handle.getFailure());
                LogAPI.logSevere((Throwable)handle.getFailure());
            }
        }
    }
}

