/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content;

import com.selima.fbi.Folder;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.waitdlg.DownloadModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.content.MessageBoxContent;
import com.selima.fbi.ui.content.MessageTransferContent;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import java.awt.Component;
import java.awt.event.ActionEvent;

public class InboxContent
extends MessageTransferContent {
    public InboxContent(MailServiceClientContext cctx) {
        super(cctx, Folder.INBOX, "/img/32x32/apps/mail_inbox3.png", "Downloading messages over internet", cctx.getCurrentUser().isAgent());
        this.toolBar.replace("Refresh", new MessageBoxContent.BewareEmptyRefreshAction(this, new InboxRefreshAction()));
    }

    @Override
    public String getContentName() {
        return "Inbox";
    }

    @Override
    public String getDescription() {
        return "Incoming messages";
    }

    @Override
    public String getHelpTopic() {
        return "content.context-help.inbox";
    }

    class InboxRefreshAction
    extends MessageBoxContent.RefreshAction {
        Component component;

        InboxRefreshAction() {
            super(InboxContent.this);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.component = (Component)evt.getSource();
            this.setEnabled(false);
            InboxContent.this.getClientContext().getSubmitter().submitWork((BackendWork)new InboxDownloadWork());
        }

        class InboxDownloadWork
        extends MessageBoxContent.DownloadWork {
            InboxDownloadWork() {
                super(InboxContent.this);
                SingletonWaitingDialog.showDialog(InboxContent.this.getClientContext(), new DownloadModel(), null);
            }

            @Override
            public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
                try {
                    super.invokeBackend(handle);
                }
                finally {
                    SingletonWaitingDialog.hideDialog();
                }
            }

            @Override
            public void invokeSwing(SwingOperationHandle handle) {
                super.invokeSwing(handle);
                InboxRefreshAction.this.setEnabled(true);
                InboxRefreshAction.this.component.requestFocusInWindow();
            }
        }
    }
}

