/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.content;

import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import com.selima.help.ui.HelpInitializer;
import com.selima.help.ui.HelpInitializerSingleton;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.help.HelpBroker;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class AbstractClientContent
extends JPanel
implements ClientContent {
    private MailServiceClientContext cctx;
    private String openingText;
    private ImageIcon icon;

    protected AbstractClientContent(MailServiceClientContext cctx, String icon, String text) {
        super(new BorderLayout());
        this.cctx = cctx;
        this.icon = SwingHelper.imageIcon(icon);
        this.openingText = text;
        this.addContextHelp();
    }

    @Override
    public BackendWork getOpeningWork() {
        return new OpeningWork();
    }

    @Override
    public BackendWork getClosingWork() {
        return null;
    }

    @Override
    public JComponent getContent() {
        return this;
    }

    @Override
    public ImageIcon getIcon() {
        return this.icon;
    }

    public MailServiceClientContext getClientContext() {
        return this.cctx;
    }

    @Override
    public boolean canClose() {
        return true;
    }

    private void addContextHelp() {
        HelpInitializer hi = HelpInitializerSingleton.getInstance();
        if (hi != null && this.getHelpTopic() != null) {
            hi.insertHelp(new HelpInitializer.HelpLoadedCallBack(){
                {
                    AbstractClientContent.this.putClientProperty("HelpInitializer.HelpLoadedCallBack", this);
                }

                public void helpLoaded(HelpBroker hb) {
                    hb.enableHelpKey((Component)AbstractClientContent.this, AbstractClientContent.this.getHelpTopic(), hb.getHelpSet(), "javax.help.SecondaryWindow", "Popup");
                }

                public void helpFailed(Exception e) {
                }
            });
        }
    }

    protected class OpeningWork
    implements BackendWork {
        protected OpeningWork() {
        }

        public String getName() {
            return AbstractClientContent.this.openingText;
        }

        public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
        }

        public void invokeSwing(SwingOperationHandle handle) {
            if (handle.getFailure() != null) {
                LogAPI.logSevere((Throwable)handle.getFailure());
            }
        }
    }
}

