/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.waitdlg;

import com.selima.fbi.DPSServiceListener;
import com.selima.fbi.NetworkListener;
import com.selima.fbi.ui.common.waitdlg.AbstractProgressModel;
import com.selima.fbi.ui.common.waitdlg.MailServiceWaiting;
import com.selima.fbi.user.IUser;
import org.w3c.dom.Element;

public class DownloadModel
extends AbstractProgressModel
implements DPSServiceListener,
NetworkListener,
MailServiceWaiting {
    String message = "Checking for new messages";
    int numOfSteps = 1;
    int currentStep;
    int stepDuration;
    long lastTime = System.currentTimeMillis();

    @Override
    public boolean isLeftToRight() {
        return false;
    }

    @Override
    public String getStepMessage() {
        return this.message;
    }

    @Override
    public String getEventDetail() {
        return null;
    }

    @Override
    public int getNumberOfSteps() {
        return this.numOfSteps;
    }

    @Override
    public int getCurrentStep() {
        return this.currentStep;
    }

    @Override
    public int getStepDuration() {
        return this.stepDuration;
    }

    @Override
    public void connecting() {
        this.message = "Connecting HMRC Services";
        this.fireChange();
    }

    @Override
    public void online() {
        this.message = "Connected Successfully";
        this.fireChange();
    }

    @Override
    public void offline() {
        this.message = "Network connection lost";
        this.fireChange();
    }

    @Override
    public void noNewMessagesOnServer() {
        this.message = "No new messages on server";
        this.fireChange();
    }

    @Override
    public void downloadStarted(int sum) {
        this.numOfSteps = sum;
        this.message = "Downloading " + sum + " message" + (sum > 0 ? "s" : "");
        this.fireChange();
    }

    @Override
    public void authorizationLost(IUser user, String name) {
        this.message = "Employer authorization lost:" + name;
        this.fireChange();
    }

    @Override
    public void authorizationGained(IUser user, String name) {
        this.message = "New Employer detected " + name;
        this.fireChange();
    }

    @Override
    public void downloaded(String name, int number) {
        this.message = "Downloaded " + name + " [" + number + "/" + this.numOfSteps + "]";
        this.currentStep = number;
        this.fireChange();
    }

    @Override
    public void malformedMessage(String message, Element element) {
    }

    @Override
    public void downloadFinished() {
        this.message = "Formatting messages for view";
        this.fireChange();
    }

    protected void fireChange() {
        long now = System.currentTimeMillis();
        this.stepDuration = (int)((now - this.lastTime) / 1000L);
        this.lastTime = now;
        this.fireStepChange();
    }

    @Override
    public void payrollCheckStarted(int sum) {
        this.message = "Payroll Check required for " + sum + " messages";
        this.numOfSteps = sum;
        this.currentStep = 0;
        this.fireChange();
    }

    @Override
    public void payrollChecked(String name) {
        this.message = "Payroll Check for " + name;
        ++this.currentStep;
        this.fireChange();
    }
}

