/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.waitdlg;

import com.selima.fbi.ui.common.waitdlg.IProgressModel;
import com.selima.fbi.ui.common.waitdlg.ProgressEvent;
import com.selima.fbi.ui.common.waitdlg.ProgressListener;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import javax.swing.SwingUtilities;

public abstract class AbstractProgressModel
implements IProgressModel {
    private boolean instepUpdate;
    EventBroadcast<ProgressListener> listeners = EventBroadcastFactory.createEventBroadcast(ProgressListener.class);

    @Override
    public void addListener(ProgressListener listener) {
        this.listeners.addListener((Object)listener);
    }

    @Override
    public void removeListener(ProgressListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    @Override
    public boolean isInstepUpdate() {
        return this.instepUpdate;
    }

    @Override
    public String[] getBackgroundImages() {
        return new String[]{"/img/anim/sending/sendmsg.background.png"};
    }

    @Override
    public String getMovingImage() {
        return "/img/anim/sending/msg.png";
    }

    @Override
    public boolean isLeftToRight() {
        return true;
    }

    protected void fireInstepChange() {
        this.instepUpdate = true;
        this.fireEvent();
    }

    protected void fireStepChange() {
        this.instepUpdate = false;
        this.fireEvent();
    }

    private void fireEvent() {
        final ProgressEvent progressEvent = new ProgressEvent(this);
        if (SwingUtilities.isEventDispatchThread()) {
            ((ProgressListener)this.listeners.getListener()).stateChanged(progressEvent);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((ProgressListener)AbstractProgressModel.this.listeners.getListener()).stateChanged(progressEvent);
                }
            });
        }
    }
}

