/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.treetable;

import com.selima.fbi.ui.common.FocusFixTable;
import com.selima.fbi.ui.common.treetable.TreeTableModel;
import com.selima.fbi.ui.common.treetable.TreeTableModelAdapter;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends FocusFixTable {
    protected TreeTableCellRenderer tree;

    public JTreeTable(TreeTableModel treeTableModel) {
        super(new DefaultTableModel(), null);
        this.tree = new TreeTableCellRenderer(treeTableModel);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.setDefaultEditor(TreeTableModel.class, new TreeTableCellEditor());
    }

    public TreeTableModelAdapter getModelAdapter() {
        return (TreeTableModelAdapter)this.getModel();
    }

    public Object getNodeForRow(int rowIndex) {
        return this.getModelAdapter().nodeForRow(rowIndex);
    }

    public TreePath getPathForRow(int rowIndex) {
        return this.getModelAdapter().pathForRow(rowIndex);
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent evt, int condition, boolean pressed) {
        boolean result = super.processKeyBinding(ks, evt, condition, pressed);
        int index = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (index >= 0 && index < this.getColumnCount() && TreeTableModel.class == this.getModel().getColumnClass(this.getColumnModel().getColumn(index).getModelIndex()) && Arrays.asList("expand", "collapse", "toggle-expansion").contains(this.tree.getInputMap(condition).get(ks))) {
            int yLead = this.getSelectionModel().getLeadSelectionIndex();
            if (this.tree.processKeyBinding(ks, new KeyEvent(this.tree, evt.getID(), evt.getWhen(), evt.getModifiers(), evt.getKeyCode(), evt.getKeyChar(), evt.getKeyLocation()), condition, pressed)) {
                this.getSelectionModel().setSelectionInterval(yLead, yLead);
                this.getColumnModel().getSelectionModel().setSelectionInterval(index, index);
            }
        }
        return result;
    }

    public JTree getTree() {
        return this.tree;
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int min = this.listSelectionModel.getMinSelectionIndex();
                    int max = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (min != -1 && max != -1) {
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JTreeTable.this.tree.getPathForRow(counter)) == null) continue;
                            this.addSelectionPath(selPath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree.getTableCellRendererComponent(table, value, isSelected, true, r, c);
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            if (evt instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != TreeTableModel.class) continue;
                    MouseEvent mevt = (MouseEvent)evt;
                    MouseEvent newME = new MouseEvent(JTreeTable.this.tree, mevt.getID(), mevt.getWhen(), mevt.getModifiers(), mevt.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, mevt.getY(), mevt.getClickCount(), mevt.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
            this.setCellRenderer(new CustomCellRenderer(this.getCellRenderer()));
            this.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "toggle-expansion");
            this.getActionMap().put("toggle-expansion", new ToggleExpansionAction());
        }

        @Override
        public boolean processKeyBinding(KeyStroke ks, KeyEvent evt, int condition, boolean pressed) {
            return super.processKeyBinding(ks, evt, condition, pressed);
        }

        @Override
        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        @Override
        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
            this.getBorder().paintBorder(this, g, 0, this.visibleRow * this.getRowHeight(), this.getWidth(), this.getRowHeight() - 1);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent original = (JComponent)table.getDefaultRenderer(Object.class).getTableCellRendererComponent(table, "", isSelected, hasFocus, row, column);
            this.setBorder(original.getBorder());
            this.setBackground(original.getBackground());
            this.setForeground(original.getForeground());
            this.setFont(original.getFont());
            this.visibleRow = row;
            return this;
        }

        class CustomCellRenderer
        implements TreeCellRenderer {
            private TreeCellRenderer renderer;

            CustomCellRenderer(TreeCellRenderer renderer) {
                this.renderer = renderer;
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (this.renderer instanceof DefaultTreeCellRenderer) {
                    DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)this.renderer;
                    dtcr.setBackgroundNonSelectionColor(tree.getBackground());
                    dtcr.setBackgroundSelectionColor(tree.getBackground());
                    dtcr.setTextSelectionColor(tree.getForeground());
                    dtcr.setTextNonSelectionColor(tree.getForeground());
                }
                JComponent result = (JComponent)this.renderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                return result;
            }
        }

        class ToggleExpansionAction
        extends AbstractAction {
            ToggleExpansionAction() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = TreeTableCellRenderer.this.getLeadSelectionRow();
                if (TreeTableCellRenderer.this.isExpanded(row)) {
                    TreeTableCellRenderer.this.collapseRow(row);
                } else {
                    TreeTableCellRenderer.this.expandRow(row);
                }
            }
        }
    }
}

