/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.treetable;

import com.selima.fbi.ui.common.treetable.JTreeTable;
import com.selima.fbi.ui.common.treetable.TreeTableModel;
import java.awt.Color;
import javax.swing.JTree;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;

public abstract class GTreeTable
extends JTreeTable {
    protected TreeTableModel treeTableModel;

    public GTreeTable(TreeTableModel treeTableModel) {
        super(treeTableModel);
        this.treeTableModel = treeTableModel;
        TableColumnModel colModel = this.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(100);
        for (int i = 1; i < colModel.getColumnCount(); ++i) {
            colModel.getColumn(i).setPreferredWidth(400);
        }
        this.setSelectionBackground(new Color(15132410));
        this.getTree().setRootVisible(false);
        this.setDefaultRenderer(Object.class, this.getTableRenderer(this.getDefaultRenderer(Object.class)));
    }

    public TreeTableModel getTreeTableModel() {
        return this.treeTableModel;
    }

    protected void expandWholeTree() {
        this.expandTree(this.getTree(), new TreePath(this.tree.getModel().getRoot()));
    }

    protected void expandTree(JTree tree, TreePath path) {
        Object lastPathComp = path.getLastPathComponent();
        int childCount = tree.getModel().getChildCount(lastPathComp);
        if (childCount > 0) {
            tree.expandPath(path);
            for (int i = 0; i < childCount; ++i) {
                Object child = tree.getModel().getChild(lastPathComp, i);
                this.expandTree(tree, path.pathByAddingChild(child));
            }
        }
    }

    protected abstract TableCellRenderer getTableRenderer(TableCellRenderer var1);
}

