/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.table;

import com.selima.fbi.ui.common.table.RowComparator;
import com.selima.fbi.ui.common.table.RowTableModelColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;

public abstract class RowTableModel<RowType>
extends AbstractTableModel {
    private TableRow<RowType>[] rows;
    private List<Sorter> sorters = new LinkedList<Sorter>();
    private RowTableModelColumn<? super RowType>[] columns;

    public RowTableModel(RowTableModelColumn<? super RowType> ... columns) {
        this.columns = columns;
    }

    public abstract Map<String, RowTableModelColumn<?>> getMapOfColumns();

    public RowTableModelColumn<? super RowType>[] getColumns() {
        return this.columns;
    }

    protected void setColumns(RowTableModelColumn<RowType>[] columns) {
        this.columns = columns;
        Iterator<Sorter> it = this.sorters.iterator();
        while (it.hasNext()) {
            if (it.next().migrate()) continue;
            it.remove();
        }
        this.fireTableStructureChanged();
    }

    protected void setRows(TableRow<RowType>[] rows) {
        this.rows = rows;
    }

    public void hideRows(String[] values, RowTableModelColumn<? super RowType> column) {
        int i;
        TableRow[] newRows = new TableRow[this.rows.length - values.length];
        Arrays.sort(values);
        int[] indexes = new int[values.length];
        int j = 0;
        int k = 0;
        for (i = 0; i < this.rows.length; ++i) {
            Object value = this.rows[i].getValueAt(column);
            if (Arrays.binarySearch(values, value) < 0) {
                newRows[j] = this.rows[i];
                newRows[j].setRowIndex(j);
                ++j;
                continue;
            }
            indexes[k++] = i;
        }
        this.rows = newRows;
        for (i = 0; i < indexes.length; ++i) {
            int start = i;
            while (i < indexes.length - 1 && indexes[i + 1] == indexes[i] + 1) {
                ++i;
            }
            this.fireTableRowsDeleted(indexes[start], indexes[i]);
        }
    }

    public void hideRowsWithValues(Object rowValue) {
        for (int i = 0; i < this.rows.length; ++i) {
            if (this.rows[i].getRowData() != rowValue) continue;
            TableRow[] newRows = new TableRow[this.rows.length - 1];
            System.arraycopy(this.rows, 0, newRows, 0, i);
            System.arraycopy(this.rows, i + 1, newRows, i, this.rows.length - 1 - i);
            this.rows = newRows;
            this.fireTableRowsDeleted(i, i);
        }
    }

    public void hideRows(List<RowType> hiddenRows) {
        int i;
        if (hiddenRows.size() == 0) {
            return;
        }
        TableRow[] newRows = new TableRow[this.rows.length - hiddenRows.size()];
        int[] indexes = new int[hiddenRows.size()];
        int j = 0;
        int k = 0;
        for (i = 0; i < this.rows.length; ++i) {
            if (hiddenRows.contains(this.rows[i].getRowData())) {
                indexes[k++] = i;
                continue;
            }
            newRows[j] = this.rows[i];
            newRows[j].setRowIndex(j);
            ++j;
        }
        this.rows = newRows;
        for (i = 0; i < indexes.length; ++i) {
            int start = i;
            while (i < indexes.length - 1 && indexes[i + 1] == indexes[i] + 1) {
                ++i;
            }
            this.fireTableRowsDeleted(indexes[start], indexes[i]);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TableRow<RowType> row = this.getRow(rowIndex);
        return row.getValueAt(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(int columnIndex) {
        List<Sorter> list = this.sorters;
        synchronized (list) {
            Sorter sorter = new Sorter(this.columns[columnIndex]);
            if (this.sorters.contains(sorter)) {
                sorter = this.sorters.remove(this.sorters.indexOf(sorter));
                sorter.flip();
            }
            this.sorters.add(sorter);
            if (this.sorters.size() > 4) {
                this.sorters.remove(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeSorting() {
        if (this.rows != null) {
            ArrayList<Sorter> copyOfSorters;
            TableRow[] copyOfrows = (TableRow[])this.rows.clone();
            List<Sorter> list = this.sorters;
            synchronized (list) {
                copyOfSorters = new ArrayList<Sorter>(this.sorters);
            }
            for (Sorter sorter : copyOfSorters) {
                sorter.sort(copyOfrows);
            }
            this.rows = copyOfrows;
        }
    }

    public boolean isColumnSortable(int columnIndex) {
        return true;
    }

    public int sortOrderOf(int columnIndex) {
        return this.sorters.indexOf(new Sorter(this.columns[columnIndex]));
    }

    public int numOfSorters() {
        return this.sorters.size();
    }

    public boolean isSortAscending(int columnIndex) {
        int index = this.sortOrderOf(columnIndex);
        if (index != -1) {
            return this.sorters.get((int)index).ascending;
        }
        return false;
    }

    public TableRow<RowType> getRow(int index) {
        return this.rows[index];
    }

    @Override
    public int getRowCount() {
        return this.rows == null ? 0 : this.rows.length;
    }

    public RowType getRowValue(int index) {
        return this.rows[index].getRowData();
    }

    class Sorter<ColumnType extends Comparable<? super ColumnType>> {
        RowTableModelColumn<?> column;
        boolean ascending = true;

        Sorter(RowTableModelColumn<?> column) {
            this.column = column;
        }

        void sort(TableRow<RowType>[] rows) {
            Arrays.sort(rows, new RowComparator(this.index(), this.ascending));
        }

        void flip() {
            this.ascending = !this.ascending;
        }

        boolean migrate() {
            for (int i = 0; i < RowTableModel.this.columns.length; ++i) {
                if (!RowTableModel.this.columns[i].getTitle().equals(this.column.getTitle())) continue;
                this.column = RowTableModel.this.columns[i];
                return true;
            }
            return false;
        }

        int index() {
            return Arrays.asList(RowTableModel.this.columns).indexOf(this.column);
        }

        public int hashCode() {
            return this.index();
        }

        public boolean equals(Object o) {
            return ((Sorter)o).column == this.column;
        }

        public String toString() {
            return "Sorter[" + this.column.getTitle() + "]";
        }
    }

    public abstract class TableRow<LocalType> {
        protected int rowIndex;

        public TableRow(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public abstract LocalType getRowData();

        public <T extends Comparable<? super T>> T getValueAt(int index) {
            RowTableModelColumn column = RowTableModel.this.columns[index];
            return (T)column.getValue(this.getRowData());
        }

        public <T extends Comparable<? super T>> T getValueAt(RowTableModelColumn<? super LocalType> col) {
            return (T)col.getValue(this.getRowData());
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        protected void setRowIndex(int rowIndex) {
            this.rowIndex = rowIndex;
        }
    }
}

