/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common.popup;

import com.selima.fbi.ui.common.RolloverBorderButton;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.popup.PopupWindow;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public abstract class AbstractPopupButton
extends RolloverBorderButton {
    PopupWindow popup;
    Icon hiddenIcon;
    Icon expandedIcon;
    static final Icon HIDDEN_ICON = SwingHelper.imageIcon("/img/16x16/actions/1downarrow.png");
    static final Icon EXPANDED_ICON = SwingHelper.imageIcon("/img/16x16/actions/1uparrow.png");

    protected AbstractPopupButton() {
        this(HIDDEN_ICON, EXPANDED_ICON);
    }

    protected AbstractPopupButton(Icon hiddenIcon, Icon expandedIcon) {
        super(hiddenIcon);
        this.hiddenIcon = hiddenIcon;
        this.expandedIcon = expandedIcon;
        Dimension size = new Dimension(27, 20);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
        this.addActionListener(new FlipActionListener());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    protected abstract JComponent createPopupContent();

    public boolean isPopupVisible() {
        return this.popup != null && this.popup.isVisible();
    }

    public void flipPopup() {
        if (this.popup == null) {
            JComponent popupContent = this.createPopupContent();
            popupContent.addAncestorListener(new IconSwitcher());
            this.popup = new PopupWindow((JFrame)SwingUtilities.getWindowAncestor(this), this, popupContent);
        }
        this.popup.flip();
    }

    public void hidePopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
    }

    class IconSwitcher
    implements AncestorListener {
        IconSwitcher() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            AbstractPopupButton.this.setIcon(AbstractPopupButton.this.expandedIcon);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            AbstractPopupButton.this.setIcon(AbstractPopupButton.this.hiddenIcon);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    class FlipActionListener
    implements ActionListener {
        FlipActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AbstractPopupButton.this.flipPopup();
        }
    }
}

