/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.ui.common.RolloverListener;
import java.awt.Component;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class ToolBar
extends JToolBar {
    public ToolBar(Object ... objects) {
        super(0);
        this.setFloatable(false);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 0));
        for (Object o : objects) {
            if (o instanceof Action) {
                this.add((Action)o);
                continue;
            }
            this.add((JComponent)o);
        }
    }

    @Override
    public JButton add(Action a) {
        return this.add(a, this.getComponentCount());
    }

    public ToolBar addTool(Action action) {
        this.add(action);
        return this;
    }

    public ToolBar addTool(Component component) {
        this.add(component);
        return this;
    }

    public ToolBar addAfter(String actionName, Action action) {
        int index = this.indexOf(actionName);
        this.add(action, index + 1);
        return this;
    }

    public ToolBar addToolAfter(String actionName, Component ... components) {
        int index = this.indexOf(actionName);
        for (Component c : components) {
            this.add(c, ++index);
        }
        return this;
    }

    public ToolBar addBefore(String actionName, Action action) {
        int index = this.indexOf(actionName);
        this.add(action, index);
        return this;
    }

    public ToolBar replace(String actionName, Action action) {
        int index = this.indexOf(actionName);
        this.remove(index);
        this.add(action, index);
        return this;
    }

    public JButton add(Action action, int index) {
        JButton button = this.createActionComponent(action);
        button.setAction(action);
        new RolloverListener(button);
        action.putValue("component", button);
        this.add((Component)button, index);
        if (action.getValue("ShortDescription") == null) {
            action.putValue("ShortDescription", action.getValue("Name"));
        }
        return button;
    }

    public ToolBar remove(String actionName) {
        this.remove(this.indexOf(actionName));
        return this;
    }

    private int indexOf(String actionName) {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            String currentName;
            AbstractButton button;
            Action action;
            Component component = this.getComponent(i);
            if (!(component instanceof AbstractButton ? (action = (button = (AbstractButton)component).getAction()) != null && actionName.equals(currentName = (String)action.getValue("Name")) : actionName.equals(component.getName()))) continue;
            return i;
        }
        return -1;
    }

    public Action[] getActions() {
        LinkedList<Action> actions = new LinkedList<Action>();
        for (Component component : this.getComponents()) {
            AbstractButton button;
            Action action;
            if (!(component instanceof AbstractButton) || (action = (button = (AbstractButton)component).getAction()) == null) continue;
            actions.add(action);
        }
        return actions.toArray(new Action[actions.size()]);
    }
}

