/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.ui.common.NullableSpinner;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.util.EventObject;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class SpinnerTableEditor
extends NullableSpinner
implements TableCellEditor {
    EventBroadcast<CellEditorListener> listeners = EventBroadcastFactory.createEventBroadcast(CellEditorListener.class);

    public SpinnerTableEditor(int minValue, int defaultValue, int maxValue) {
        super(minValue, defaultValue, maxValue);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setValue(value);
        return this;
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.addListener((Object)l);
    }

    @Override
    public void cancelCellEditing() {
        this.setValue(this.getValue());
        ((CellEditorListener)this.listeners.getListener()).editingCanceled(new ChangeEvent(this));
    }

    @Override
    public Object getCellEditorValue() {
        return this.getValue();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)anEvent;
            return mouseEvent.getClickCount() == 2;
        }
        if (anEvent instanceof KeyEvent) {
            return true;
        }
        return anEvent instanceof ActionEvent;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean result = super.processKeyBinding(ks, e, condition, pressed);
        if (!result && condition == 0 && (result = this.forwardKeyBindingsToTextField(e, ks))) {
            this.getTextField().requestFocusInWindow();
        }
        return result;
    }

    private boolean forwardKeyBindingsToTextField(KeyEvent e, KeyStroke keyStroke) {
        Action action;
        Object actionId = this.getTextField().getInputMap(0).get(keyStroke);
        if (actionId != null && (action = this.getTextField().getActionMap().get(actionId)) != null) {
            return SwingUtilities.notifyAction(action, keyStroke, e, this.getTextField(), 0);
        }
        return false;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.removeListener((Object)l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.getTextField().commitEdit();
        }
        catch (ParseException ignored) {
            LogAPI.logWarning((Throwable)ignored);
        }
        ((CellEditorListener)this.listeners.getListener()).editingStopped(new ChangeEvent(this));
        return true;
    }
}

