/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.ui.common.FileFormatAccessory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;

class PageAndFormatAccessory
extends FileFormatAccessory {
    PagesOptions pagesOptions = new PagesOptions();

    PageAndFormatAccessory() {
        super(new CustomFormatOptions());
        this.pagesOptions.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PageAndFormatAccessory.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
        ((CustomFormatOptions)this.formatOptions).setRangeGroup(this.pagesOptions);
        this.add(new FileFormatAccessory.OptionsPanel("Pages", this.pagesOptions));
    }

    public boolean isCurrentOnly() {
        return this.pagesOptions.isCurrentOnly();
    }

    public boolean isAllPages() {
        return this.pagesOptions.isAllPages();
    }

    static class PagesOptions
    extends FileFormatAccessory.Options {
        PropertyChangeListener pcl;
        String htmlModeValue = "Current";
        boolean xmlMode;

        public PagesOptions() {
            super("Current", "Current", "All Pages");
        }

        void toXMLMode(boolean state) {
            if (this.xmlMode != state) {
                this.xmlMode = state;
                if (state) {
                    this.htmlModeValue = this.getSelection().getActionCommand();
                    this.setSelectedOption("All Pages");
                    this.setEnabled(false);
                } else {
                    this.setSelectedOption(this.htmlModeValue);
                    this.setEnabled(true);
                }
            }
        }

        public boolean isCurrentOnly() {
            return "Current".equals(this.getSelectedOption());
        }

        public boolean isAllPages() {
            return "All Pages".equals(this.getSelectedOption());
        }

        @Override
        public void setSelected(ButtonModel m, boolean b) {
            boolean wasCurrentOnly = this.isCurrentOnly();
            boolean wasAllPages = this.isAllPages();
            super.setSelected(m, b);
            if (this.pcl != null) {
                this.pcl.propertyChange(new PropertyChangeEvent(this, "currentOnly", wasCurrentOnly, this.isCurrentOnly()));
                this.pcl.propertyChange(new PropertyChangeEvent(this, "allPages", wasAllPages, this.isAllPages()));
            }
        }
    }

    static class CustomFormatOptions
    extends FileFormatAccessory.FormatOptions {
        PagesOptions pagesGroup;

        CustomFormatOptions() {
        }

        void setRangeGroup(PagesOptions rangeGroup) {
            this.pagesGroup = rangeGroup;
            this.pagesGroup.toXMLMode(this.isXml());
        }

        @Override
        public void setSelected(ButtonModel m, boolean b) {
            boolean goahead = b && m != null && m != this.getSelection();
            super.setSelected(m, b);
            if (this.pagesGroup != null && goahead) {
                this.pagesGroup.toXMLMode(this.isXml());
            }
        }
    }
}

