/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.framework.util.Util;
import java.awt.Dimension;
import java.text.ParseException;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;

public class NullableSpinner
extends JSpinner {
    public NullableSpinner(int minimumValue, int defaultValue, int maximumValue) {
        super(new NullableNumberSpinnerModel(minimumValue, defaultValue, maximumValue));
        JFormattedTextField textField = this.getTextField();
        textField.setFormatterFactory(new NullableFormatterFactory());
        textField.setEditable(true);
        Dimension preferredSize = textField.getPreferredSize();
        preferredSize.width = 25;
        textField.setPreferredSize(preferredSize);
    }

    protected JFormattedTextField getTextField() {
        return ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
    }

    static class NullableNumberSpinnerModel
    extends AbstractSpinnerModel {
        Integer value;
        final int defaultValue;
        final int minimum;
        final int maximum;

        public NullableNumberSpinnerModel(int minimum, int defaultValue, int maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
            this.defaultValue = defaultValue;
        }

        @Override
        public Object getNextValue() {
            int result = this.value == null ? this.defaultValue : this.value + 1;
            return result > this.maximum ? null : Integer.valueOf(result);
        }

        @Override
        public Object getPreviousValue() {
            int result = this.value == null ? this.defaultValue : this.value - 1;
            return result < this.minimum ? null : Integer.valueOf(result);
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            Integer integer;
            if (value != null && ((integer = (Integer)value) < this.minimum || integer > this.maximum)) {
                return;
            }
            boolean change = !Util.equals((Object)this.value, (Object)value);
            this.value = (Integer)value;
            if (change) {
                this.fireStateChanged();
            }
        }
    }

    static class NullableNumberFormatter
    extends JFormattedTextField.AbstractFormatter {
        NullableNumberFormatter() {
        }

        @Override
        public Object stringToValue(String text) throws ParseException {
            if (text.length() > 0) {
                try {
                    return Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    throw new ParseException(text, 0);
                }
            }
            return null;
        }

        @Override
        public String valueToString(Object value) throws ParseException {
            if (value != null) {
                return value.toString();
            }
            return "";
        }
    }

    static class NullableFormatterFactory
    extends JFormattedTextField.AbstractFormatterFactory {
        NullableFormatterFactory() {
        }

        @Override
        public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
            return new NullableNumberFormatter();
        }
    }
}

