/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.ui.common.ExpandableLayout;
import com.selima.fbi.ui.common.SortIcon;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;

public class FlipExpandableLayoutAction
extends AbstractAction {
    private JComponent container;

    public FlipExpandableLayoutAction(JComponent container) {
        this.container = container;
        boolean minimized = this.queryPanelLayout().isMinimized();
        this.setIcon(minimized);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ExpandableLayout layout;
        boolean minimized = (layout = this.queryPanelLayout()).isMinimized();
        layout.setMinimized(!minimized);
        this.setIcon(!minimized);
        this.container.invalidate();
        this.container.getParent().validate();
    }

    private ExpandableLayout queryPanelLayout() {
        return (ExpandableLayout)this.container.getLayout();
    }

    private void setIcon(boolean minimized) {
        this.putValue("SmallIcon", new SortIcon(minimized ? 2 : 1, 16));
    }
}

