/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.util.IOUtil;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JRadioButton;

class FileFormatAccessory
extends Box {
    protected FormatOptions formatOptions;

    FileFormatAccessory() {
        this(new FormatOptions());
    }

    FileFormatAccessory(FormatOptions formatOptions) {
        super(1);
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.formatOptions = formatOptions;
        this.add(new OptionsPanel("Format:", formatOptions));
        formatOptions.listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FileFormatAccessory.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        };
    }

    public boolean isXml() {
        return this.formatOptions.isXml();
    }

    public boolean isHtml() {
        return this.formatOptions.isHtml();
    }

    public void selectExtension(File file) {
        this.formatOptions.selectExtension(file);
    }

    static class OptionsPanel
    extends Box {
        public OptionsPanel(String title, ButtonGroup buttonGroup) {
            super(1);
            this.setBorder(BorderFactory.createTitledBorder(title));
            for (AbstractButton button : Collections.list(buttonGroup.getElements())) {
                this.add(button);
            }
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        }
    }

    static class Options
    extends ButtonGroup {
        public Options(String defaultOption, String ... options) {
            for (String option : options) {
                JRadioButton radioButton = new JRadioButton(option);
                radioButton.setActionCommand(option);
                this.add(radioButton);
                if (defaultOption == null || !defaultOption.equals(option)) continue;
                this.setSelected(radioButton.getModel(), true);
            }
        }

        public void setSelectedOption(String option) {
            if (option != null) {
                for (AbstractButton button : Collections.list(this.getElements())) {
                    if (!option.equals(button.getText())) continue;
                    this.setSelected(button.getModel(), true);
                    return;
                }
            }
        }

        public String getSelectedOption() {
            ButtonModel model = this.getSelection();
            return model != null ? model.getActionCommand() : null;
        }

        public void setEnabled(boolean state) {
            for (AbstractButton button : Collections.list(this.getElements())) {
                button.setEnabled(state);
            }
        }
    }

    static class FormatOptions
    extends Options {
        PropertyChangeListener listener;

        public FormatOptions() {
            super(FormatOptions.getSaveExtension(), "XML", "HTML");
        }

        @Override
        public void setSelected(ButtonModel m, boolean b) {
            boolean wasXml = this.isXml();
            boolean wasHtml = this.isHtml();
            super.setSelected(m, b);
            if (this.listener != null) {
                this.listener.propertyChange(new PropertyChangeEvent(this, "xml", wasXml, this.isXml()));
                this.listener.propertyChange(new PropertyChangeEvent(this, "html", wasHtml, this.isHtml()));
            }
            FormatOptions.setSaveExtension(this.getSelectedOption());
        }

        public void selectExtension(File file) {
            String extension = IOUtil.getExtension(file);
            if (extension != null && extension.length() > 1) {
                String value = extension.substring(1).toUpperCase();
                this.setSelectedOption(value);
            }
        }

        public boolean isXml() {
            return "XML".equals(this.getSelectedOption());
        }

        public boolean isHtml() {
            return "HTML".equals(this.getSelectedOption());
        }

        static String getSaveExtension() {
            Preferences prefs = Preferences.userNodeForPackage(SwingHelper.class);
            return prefs.get("save-ext", "XML");
        }

        static void setSaveExtension(String text) {
            Preferences prefs = Preferences.userNodeForPackage(SwingHelper.class);
            prefs.put("save-ext", text);
        }
    }
}

