/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.util.ArrayList;
import java.util.List;

public class ExpandableLayout
implements LayoutManager2 {
    public static final String RIGHT = "Right";
    public static final String CENTER = "Center";
    public static final int PREFERRED_COMPONENTS_PER_ROW = 6;
    private Component rightComponent;
    private boolean minimized = false;
    private int hgap;
    private int vgap;

    public ExpandableLayout() {
        this(5, 5);
    }

    public ExpandableLayout(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean minimized) {
        this.minimized = minimized;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        if (RIGHT.equals(name)) {
            this.rightComponent = comp;
        }
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        String consts = (String)constraints;
        this.addLayoutComponent(consts, comp);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        if (this.rightComponent == comp) {
            this.rightComponent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            int size;
            Geometry geometry = this.isMinimized() ? new CollapsedGeometry(target) : new ExpandedGeometry(target);
            HeightCounter counter = new HeightCounter(this.vgap, target.getInsets().top, target.getInsets().bottom);
            for (int row = 0; row < geometry.getRowCount(); ++row) {
                counter.addMaximum(geometry.getComponentsInRow(row));
            }
            if (this.rightComponent != null && (size = new HeightCounter(this.vgap, target.getInsets().top, target.getInsets().bottom).add(this.rightComponent).getSize()) > counter.getSize()) {
                return new Dimension(geometry.getWidth(), size);
            }
            Dimension result = new Dimension(geometry.getWidth(), counter.getSize());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension result = this.rightComponent != null ? this.rightComponent.getMinimumSize() : new Dimension();
            return result;
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        Dimension result = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Geometry geometry = this.isMinimized() ? new CollapsedGeometry(target) : new ExpandedGeometry(target);
            HeightCounter hcounter = new HeightCounter(this.vgap, target.getInsets().top, target.getInsets().bottom);
            for (int row = 0; row < geometry.getRowCount(); ++row) {
                int rowOffset = hcounter.getNextStart();
                hcounter.addMaximum(geometry.getComponentsInRow(row));
                int rowHeight = hcounter.getLastEnd() - rowOffset;
                if (hcounter.getSize() > target.getSize().height) break;
                Component[] comps = geometry.getComponentsInRow(row);
                for (int i = 0; i < comps.length; ++i) {
                    Dimension d = comps[i].getPreferredSize();
                    comps[i].setBounds(geometry.getColumnOffset(i), rowOffset + (rowHeight - d.height) / 2, geometry.getColumnWidth(i), d.height);
                    comps[i].setVisible(true);
                }
            }
            for (int i = row * geometry.getColumnCount(); i < geometry.getComponentCount(); ++i) {
                geometry.getComponent(i).setVisible(false);
            }
            if (this.rightComponent != null) {
                Dimension dim = this.rightComponent.getPreferredSize();
                int maxW = target.getWidth() - target.getInsets().right - this.hgap - geometry.getRightComponentOffset();
                int maxH = target.getHeight() - target.getInsets().bottom - target.getInsets().top - 2 * this.vgap;
                this.rightComponent.setBounds(geometry.getRightComponentOffset(), target.getInsets().top, Math.min(dim.width, maxW), Math.min(dim.height, maxH));
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + "]";
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    private class CollapsedGeometry
    extends Geometry {
        CollapsedGeometry(Container container) {
            super(container);
        }

        @Override
        public Geometry.Position adaptFreeWidth(int inset1, int inset2) {
            Geometry.Position result = new Geometry.Position();
            result.columnCount = Math.min(this.getComponentCount(), 6);
            result.rowCount = 1;
            result.offsets = new int[result.columnCount];
            result.colWidth = new int[result.columnCount];
            WidthCounter counter = new WidthCounter(ExpandableLayout.this.hgap, inset1, inset2);
            for (int i = 0; i < result.columnCount; ++i) {
                result.offsets[i] = counter.getNextStart();
                counter.add(this.getComponent(i));
                result.colWidth[i] = counter.getLastEnd() - result.offsets[i];
            }
            if (ExpandableLayout.this.rightComponent != null) {
                result.rightComponentOffset = counter.getNextStart();
                counter.add(ExpandableLayout.this.rightComponent);
            }
            result.width = counter.getSize();
            return result;
        }

        @Override
        protected Geometry.Position adaptFixedWidth(int inset1, int inset2, int limit) {
            Geometry.Position result = new Geometry.Position();
            result.rowCount = 1;
            WidthCounter counter = new WidthCounter(ExpandableLayout.this.hgap, inset2, inset1);
            if (ExpandableLayout.this.rightComponent != null) {
                counter.add(ExpandableLayout.this.rightComponent);
            }
            if (counter.getSize() < limit) {
                int size = limit - counter.getSize();
                while (result.columnCount < this.getComponentCount()) {
                    counter.add(this.getComponent(result.columnCount));
                    counter.add(this.getComponent(result.columnCount + 1));
                    if (counter.getSize() > limit) break;
                    result.columnCount += 2;
                }
                if (result.columnCount > 0) {
                    counter = new WidthCounter(ExpandableLayout.this.hgap, inset1, inset2);
                } else if (size > 60 && this.getComponentCount() >= 2) {
                    counter = new LimitedWidthCounter(ExpandableLayout.this.hgap, size);
                    result.columnCount = 2;
                }
            }
            result.offsets = new int[result.columnCount];
            result.colWidth = new int[result.columnCount];
            for (int i = 0; i < result.columnCount; ++i) {
                result.offsets[i] = counter.getNextStart();
                counter.add(this.getComponent(i));
                result.colWidth[i] = counter.getLastEnd() - result.offsets[i];
            }
            if (ExpandableLayout.this.rightComponent != null) {
                result.rightComponentOffset = limit - new WidthCounter(ExpandableLayout.this.hgap, inset2, inset1).add(ExpandableLayout.this.rightComponent).getLastEnd();
            }
            result.width = limit;
            return result;
        }

        class LimitedWidthCounter
        extends WidthCounter {
            private int sum;
            private int space;

            LimitedWidthCounter(int gap, int space) {
                super(gap, 0, 0);
                int left = super.componentSize(CollapsedGeometry.this.getComponent(0));
                int right = super.componentSize(CollapsedGeometry.this.getComponent(1));
                this.sum = left + right;
                this.space = space - 3 * gap;
            }

            @Override
            int componentSize(Component c) {
                return this.space * super.componentSize(c) / this.sum;
            }
        }
    }

    private class ExpandedGeometry
    extends Geometry {
        ExpandedGeometry(Container container) {
            super(container);
        }

        @Override
        protected Geometry.Position adaptFixedWidth(int inset1, int inset2, int limit) {
            Geometry.Position result = new Geometry.Position();
            for (int columnCount = this.getComponentCount(); columnCount >= 2; columnCount -= 2) {
                this.adaptToColumnCount(result, new WidthCounter(ExpandableLayout.this.hgap, inset1, inset2), columnCount);
                if (result.width > limit) continue;
                result.width = limit;
                if (ExpandableLayout.this.rightComponent == null) break;
                result.rightComponentOffset = limit - new WidthCounter(ExpandableLayout.this.hgap, inset2, inset1).add(ExpandableLayout.this.rightComponent).getLastEnd();
                break;
            }
            if (result.width > limit || this.getComponentCount() < 2) {
                int spareSpace;
                if (ExpandableLayout.this.rightComponent != null) {
                    result.rightComponentOffset = Math.max(new WidthCounter(ExpandableLayout.this.hgap, inset1, inset2).getNextStart(), limit - new WidthCounter(ExpandableLayout.this.hgap, inset2, inset1).add(ExpandableLayout.this.rightComponent).getLastEnd());
                }
                if ((spareSpace = ExpandableLayout.this.rightComponent == null ? limit - inset1 - inset2 : result.rightComponentOffset - inset1 - ExpandableLayout.this.hgap) > 60 && this.getComponentCount() >= 2) {
                    LimitedWidthCounter mwc = new LimitedWidthCounter(ExpandableLayout.this.hgap, spareSpace);
                    this.adaptToColumnCount(result, mwc, 2);
                } else {
                    result.columnCount = 0;
                    result.rowCount = 0;
                    result.offsets = null;
                    result.colWidth = null;
                    result.width = limit;
                }
            }
            return result;
        }

        private Geometry.Position adaptToColumnCount(Geometry.Position position, SizeCounter counter, int columnCount) {
            position.columnCount = columnCount;
            position.rowCount = this.divideWithCeil(this.getComponentCount(), columnCount);
            position.offsets = new int[columnCount];
            position.colWidth = new int[columnCount];
            for (int column = 0; column < columnCount; ++column) {
                position.offsets[column] = counter.getNextStart();
                counter.addMaximum(this.getComponentsInColumn(column, columnCount, position.rowCount));
                position.colWidth[column] = counter.getLastEnd() - position.offsets[column];
            }
            if (ExpandableLayout.this.rightComponent != null) {
                position.rightComponentOffset = counter.getNextStart();
                counter.add(ExpandableLayout.this.rightComponent);
            }
            position.width = counter.getSize();
            return position;
        }

        @Override
        public Geometry.Position adaptFreeWidth(int inset1, int inset2) {
            Geometry.Position result = new Geometry.Position();
            int columnCount = Math.min(this.getComponentCount(), 6);
            if (columnCount >= 2) {
                this.adaptToColumnCount(result, new WidthCounter(ExpandableLayout.this.hgap, inset1, inset2), columnCount);
            } else {
                result.columnCount = 0;
                result.rowCount = 0;
                result.offsets = null;
                result.colWidth = null;
            }
            return result;
        }

        class LimitedWidthCounter
        extends WidthCounter {
            private int sum;
            private int space;

            LimitedWidthCounter(int gap, int space) {
                super(gap, 0, 0);
                int nrows = ExpandedGeometry.this.divideWithCeil(ExpandedGeometry.this.getComponentCount(), 2);
                int left = super.getMaximum(ExpandedGeometry.this.getComponentsInColumn(0, 2, nrows));
                int right = super.getMaximum(ExpandedGeometry.this.getComponentsInColumn(1, 2, nrows));
                this.sum = left + right;
                this.space = space - 3 * gap;
            }

            @Override
            int getMaximum(Component[] comps) {
                return super.getMaximum(comps) * this.space / this.sum;
            }
        }
    }

    private abstract class Geometry {
        protected Position position;
        private List<Component> components;

        protected Geometry(Container target) {
            this.readComponents(target);
            this.position = target.getWidth() == 0 ? this.adaptFreeWidth(target.getInsets().left, target.getInsets().right) : this.adaptFixedWidth(target.getInsets().left, target.getInsets().right, target.getWidth());
        }

        protected abstract Position adaptFixedWidth(int var1, int var2, int var3);

        protected abstract Position adaptFreeWidth(int var1, int var2);

        Component getComponent(int row, int col) {
            return this.getComponent(row * this.getColumnCount() + col);
        }

        Component getComponent(int i) {
            return this.components.get(i);
        }

        Component[] getComponentsInColumn(int column) {
            return this.getComponentsInColumn(column, this.getColumnCount(), this.getRowCount());
        }

        Component[] getComponentsInRow(int row) {
            return this.getComponentsInRow(row, this.getColumnCount(), this.getRowCount());
        }

        int getComponentCount() {
            return this.components.size();
        }

        int getWidth() {
            return this.position.width;
        }

        int getColumnWidth(int i) {
            return this.position.colWidth[i];
        }

        int getColumnCount() {
            return this.position.columnCount;
        }

        int getColumnOffset(int i) {
            return this.position.offsets[i];
        }

        int getRightComponentOffset() {
            return this.position.rightComponentOffset;
        }

        int getRowCount() {
            return this.position.rowCount;
        }

        private void readComponents(Container target) {
            this.components = new ArrayList<Component>(target.getComponentCount());
            for (int i = 0; i < target.getComponentCount(); ++i) {
                Component m = target.getComponent(i);
                if (m == ExpandableLayout.this.rightComponent) continue;
                this.components.add(m);
            }
            if (this.components.size() % 2 == 1) {
                throw new AssertionError((Object)"This Layout is expected to work for  <label,editor> pairs, there must not  be odd number of components");
            }
        }

        protected Component[] getComponentsInColumn(int column, int columnCount, int rowCount) {
            int row;
            ArrayList<Component> result = new ArrayList<Component>();
            for (row = 0; row < rowCount - 1; ++row) {
                result.add(this.getComponent(row * columnCount + column));
            }
            int lastIndex = row * columnCount + column;
            if (lastIndex < this.getComponentCount()) {
                result.add(this.getComponent(lastIndex));
            }
            return result.toArray(new Component[result.size()]);
        }

        protected Component[] getComponentsInRow(int row, int columnCount, int rowCount) {
            ArrayList<Component> result = new ArrayList<Component>();
            if (row < rowCount - 1) {
                int base = row * columnCount;
                for (int column = 0; column < columnCount; ++column) {
                    result.add(this.getComponent(base + column));
                }
            } else {
                int index;
                int limit = Math.min(this.getComponentCount(), index + columnCount);
                for (index = row * columnCount; index < limit; ++index) {
                    result.add(this.getComponent(index));
                }
            }
            return result.toArray(new Component[result.size()]);
        }

        protected int divideWithCeil(int numerator, int devisor) {
            return (numerator + devisor - 1) / devisor;
        }

        protected class Position {
            int columnCount;
            int rowCount;
            int[] offsets;
            int[] colWidth;
            int rightComponentOffset;
            int width;

            protected Position() {
            }
        }
    }

    private static abstract class SizeCounter {
        private boolean first = true;
        private int gap;
        private int inset2;
        private int size;

        SizeCounter(int gap, int inset1, int inset2) {
            this.gap = gap;
            this.inset2 = inset2;
            this.size = inset1;
        }

        SizeCounter add(Component c) {
            return this.add(this.componentSize(c));
        }

        SizeCounter addMaximum(Component[] comps) {
            return this.add(this.getMaximum(comps));
        }

        int getMaximum(Component[] comps) {
            int max = 0;
            for (int i = 0; i < comps.length; ++i) {
                int size = this.componentSize(comps[i]);
                if (max >= size) continue;
                max = size;
            }
            return max;
        }

        SizeCounter add(int amount) {
            if (this.first) {
                this.first = false;
                this.size += this.gap;
            }
            this.size += amount;
            this.size += this.gap;
            return this;
        }

        abstract int componentSize(Component var1);

        int getNextStart() {
            if (this.first) {
                return this.size + this.gap;
            }
            return this.size;
        }

        int getLastEnd() {
            if (this.first) {
                return this.size;
            }
            return this.size - this.gap;
        }

        int getSize() {
            return this.size + this.inset2;
        }
    }

    private static class HeightCounter
    extends SizeCounter {
        HeightCounter(int gap, int sInset, int eInset) {
            super(gap, sInset, eInset);
        }

        @Override
        int componentSize(Component c) {
            return c.getPreferredSize().height;
        }
    }

    private static class WidthCounter
    extends SizeCounter {
        WidthCounter(int gap, int sInset, int eInset) {
            super(gap, sInset, eInset);
        }

        @Override
        int componentSize(Component c) {
            return c.getPreferredSize().width;
        }
    }
}

