/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.ui.common.RepaintManagerFilter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;

public class DispatchingRepaintManager
extends RepaintManager {
    List<RepaintManagerFilter> filters = new ArrayList<RepaintManagerFilter>(2);

    public void install() {
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        RepaintManager.setCurrentManager(DispatchingRepaintManager.this);
                    }
                });
            } else {
                RepaintManager.setCurrentManager(this);
            }
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(String.valueOf(e.getCause()));
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            throw new IllegalStateException("Instalation failed");
        }
    }

    @Override
    public synchronized void addDirtyRegion(JComponent component, int x, int y, int w, int h) {
        for (RepaintManagerFilter filter : this.filters) {
            if (filter.addDirtyRegion(component)) continue;
            return;
        }
        super.addDirtyRegion(component, x, y, w, h);
    }

    public synchronized void addDirtyRegionBypassFilters(JComponent component, int x, int y, int w, int h) {
        super.addDirtyRegion(component, x, y, w, h);
    }

    @Override
    public synchronized void addInvalidComponent(JComponent component) {
        for (RepaintManagerFilter filter : this.filters) {
            if (filter.addInvalidComponent(component)) continue;
            return;
        }
        super.addInvalidComponent(component);
    }

    public synchronized void addFilter(RepaintManagerFilter filter) {
        this.filters.add(filter);
    }

    public synchronized void removeFilter(RepaintManagerFilter filter) {
        this.filters.remove(filter);
    }
}

