/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.core.IDPSMessage;
import com.selima.fbi.core.IMailMessage;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.FBIFileChooser;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.waitdlg.BackendWorkInterrupter;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.fbi.util.IOUtil;
import com.selima.fbi.webserver.WebServerException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;

public abstract class AbstractSaveAction
extends AbstractAction {
    private MailServiceClientContext clientContext;

    protected AbstractSaveAction(MailServiceClientContext clientContext) {
        super("Save", SwingHelper.imageIcon("/img/16x16/actions/filesave.png"));
        this.clientContext = clientContext;
    }

    protected MailServiceClientContext clientContext() {
        return this.clientContext;
    }

    protected abstract FBIFileChooser createFileChooser() throws WebServerException, IOException;

    protected abstract void performSave(FBIFileChooser var1, BackendOperationHandle var2) throws IOException, WebServerException, CanceledException;

    protected String baseName(IMailMessage message) {
        StringBuilder result = new StringBuilder();
        if (message instanceof IDPSMessage) {
            result.append((Object)message.getFormType()).append('_').append(message.getEmpRef()).append('_').append(((IDPSMessage)message).getSequenceNumber()).append('_');
        }
        result.append(message.getSubject());
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            switch (c) {
                case '/': 
                case '\\': {
                    c = '-';
                    break;
                }
                case '(': 
                case ')': {
                    c = '_';
                    break;
                }
                default: {
                    if (!Character.isWhitespace(c)) break;
                    c = '_';
                }
            }
            if (c == '_' && i > 0 && result.charAt(i - 1) == '_') {
                result.deleteCharAt(i--);
                continue;
            }
            result.setCharAt(i, c);
        }
        return IOUtil.idToFile(result.toString());
    }

    @Override
    public void actionPerformed(final ActionEvent evt) {
        this.clientContext().getSubmitter().submitWork(new BackendWork(){

            public String getName() {
                return "Preparing File chooser dialog";
            }

            public void invokeBackend(BackendOperationHandle handle) {
                try {
                    handle.setResult((Object)AbstractSaveAction.this.createFileChooser());
                }
                catch (WebServerException e) {
                    handle.setFailure((Throwable)e);
                }
                catch (IOException e) {
                    handle.setFailure((Throwable)e);
                }
            }

            public void invokeSwing(final SwingOperationHandle handle) {
                if (handle.getResult() != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AbstractSaveAction.this.showFileChooser((FBIFileChooser)handle.getResult(), (Component)evt.getSource());
                        }
                    });
                } else {
                    FailureDialog.show(AbstractSaveAction.this.clientContext().getTitle(), "<html>Failed to start <b>File chooser dialog</b></html>", handle.getFailure());
                    LogAPI.logSevere((Throwable)handle.getFailure());
                }
            }
        });
    }

    private void showFileChooser(final FBIFileChooser fileChooser, Component component) {
        int result = fileChooser.showSaveDialog(SwingUtilities.windowForComponent(component));
        final File saveFile = fileChooser.getSelectedFile();
        if (result == 0) {
            final boolean directory = saveFile.isDirectory();
            BackendWorkInterrupter interrupter = this.showProgressBar(fileChooser);
            SwingOperationHandle handle = this.clientContext().getSubmitter().submitWork(new BackendWork(){

                public String getName() {
                    return (directory ? "Saving messages to " : "Saving message to ") + saveFile.getPath();
                }

                public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
                    try {
                        AbstractSaveAction.this.performSave(fileChooser, handle);
                    }
                    catch (IOException e) {
                        handle.setFailure((Throwable)e);
                    }
                    catch (WebServerException e) {
                        handle.setFailure((Throwable)e);
                    }
                }

                public void invokeSwing(SwingOperationHandle handle) {
                    AbstractSaveAction.this.hideProgressBar();
                    if (handle.getFailure() != null && !(handle.getFailure() instanceof CanceledException)) {
                        FailureDialog.show(AbstractSaveAction.this.clientContext().getTitle(), "<html><b>Failed to save message</b></html>", handle.getFailure());
                        LogAPI.logSevere((Throwable)handle.getFailure());
                    }
                }
            });
            if (interrupter != null) {
                interrupter.setTaskHandle(handle);
            }
        }
    }

    protected boolean preferredXml(File file, boolean defValue) {
        String extension = IOUtil.getExtension(file);
        if (extension.length() > 0) {
            if (".xml".equalsIgnoreCase(extension)) {
                return true;
            }
            if (".html".equalsIgnoreCase(extension) || ".htm".equalsIgnoreCase(extension)) {
                return false;
            }
        }
        return defValue;
    }

    protected File preferredFile(File file, boolean preferredXml) {
        String extension = IOUtil.getExtension(file);
        if (extension.length() == 0) {
            extension = preferredXml ? ".xml" : ".html";
            return new File(file.getParentFile(), file.getName() + extension);
        }
        return file;
    }

    protected BackendWorkInterrupter showProgressBar(FBIFileChooser fileChooser) {
        return null;
    }

    protected void hideProgressBar() {
    }
}

