/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui.common;

import com.selima.fbi.CancelException;
import com.selima.fbi.service.DPSException;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.common.waitdlg.TaxRefCheckModel;
import com.selima.fbi.ui.edialog.FailureDialog;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public abstract class AbstractAddEmpRefAction
extends AbstractAction {
    protected final MailServiceClientContext context;

    protected AbstractAddEmpRefAction(MailServiceClientContext context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Component component = (Component)evt.getSource();
        String empRef = JOptionPane.showInputDialog(SwingUtilities.getWindowAncestor(component), "<html><H3>Enter Employer Reference</H3>In form 123/ABCD4567</html>", this.context.getTitle(), 3);
        if (empRef != null && empRef.length() > 0 && this.goAheadFor(empRef.toUpperCase())) {
            this.setEnabled(false);
            EmpRefWork work = new EmpRefWork(component, empRef.toUpperCase());
            work.setTaskHandle(this.context.getSubmitter().submitWork((BackendWork)work));
        }
    }

    protected abstract boolean goAheadFor(String var1);

    protected abstract void verifiedSuccessfully(String var1);

    protected abstract boolean verifyAccess(String var1) throws DPSException, RemoteException, CancelException, IOException;

    class EmpRefWork
    extends BasicInterrupter
    implements BackendWork {
        final String empRef;
        final Component component;
        final TaxRefCheckModel progressModel;

        EmpRefWork(Component component, String empRef) {
            this.empRef = empRef;
            this.component = component;
            this.progressModel = new TaxRefCheckModel(empRef);
            SingletonWaitingDialog.showDialog(AbstractAddEmpRefAction.this.context, this.progressModel, this);
        }

        public String getName() {
            return "Verifying access to '" + this.empRef + "'";
        }

        public void invokeBackend(BackendOperationHandle handle) throws CanceledException {
            try {
                boolean result = AbstractAddEmpRefAction.this.verifyAccess(this.empRef);
                this.progressModel.finished();
                handle.setResult((Object)result);
            }
            catch (DPSException e) {
                handle.setFailure((Throwable)e);
            }
            catch (RemoteException e) {
                handle.setFailure((Throwable)e);
            }
            catch (IOException e) {
                handle.setFailure((Throwable)e);
            }
            catch (CancelException e) {
                throw new CanceledException((Exception)e);
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
            SingletonWaitingDialog.hideDialog();
            if (Boolean.TRUE == handle.getResult()) {
                AbstractAddEmpRefAction.this.context.getStatusBar().displayMessage("Successfully verified authorisation for '" + this.empRef + "'");
                AbstractAddEmpRefAction.this.verifiedSuccessfully(this.empRef);
            } else if (Boolean.FALSE == handle.getResult()) {
                if (AbstractAddEmpRefAction.this.context.isOnline()) {
                    AbstractAddEmpRefAction.this.context.getStatusBar().displayMessage("'" + AbstractAddEmpRefAction.this.context.getCurrentUser().getLogin() + "' is not authorised to access '" + this.empRef + "'");
                    JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this.component), "<html><b>" + AbstractAddEmpRefAction.this.context.getCurrentUser().getLogin() + "</b> is not authorised to access <b>" + this.empRef + "</b></html>", AbstractAddEmpRefAction.this.context.getTitle(), -1, 2);
                } else {
                    AbstractAddEmpRefAction.this.context.getStatusBar().displayMessage("Authorisation attempt failed because of network conditions");
                    JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this.component), "Authorisation attempt failed because of network conditions", AbstractAddEmpRefAction.this.context.getTitle(), -1, 2);
                }
            } else if (!(handle.getFailure() instanceof CanceledException)) {
                FailureDialog.show(AbstractAddEmpRefAction.this.context.getTitle(), "Unexpected failure verifying authorisation for <b>" + this.empRef + "</b>", handle.getFailure());
                LogAPI.logSevere((Throwable)handle.getFailure());
            }
            AbstractAddEmpRefAction.this.setEnabled(true);
            this.component.requestFocusInWindow();
        }
    }
}

