/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui;

import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.NetworkListener;
import com.selima.fbi.threading.GWImageSupplyFactory;
import com.selima.fbi.threading.GWPanel;
import com.selima.fbi.ui.GenericEDTListener;
import com.selima.fbi.ui.IStatusBar;
import com.selima.fbi.ui.common.RolloverBorderButton;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.waitdlg.IWaitingInterrupter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class StatusBar
extends Box
implements IStatusBar {
    private JLabel messageLabel;
    private CancelAction cancelAction;
    private ConnectivityLabel connectivityLabel;

    public StatusBar() {
        super(0);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.messageLabel = new JLabel();
        this.add(this.messageLabel);
        this.add(StatusBar.createGlue());
        this.connectivityLabel = new ConnectivityLabel();
        this.add(this.connectivityLabel);
        GWPanel gwPanel = new GWPanel(GWImageSupplyFactory.createMovingImageSupply("/img/16x16/progressbar/logo.png", 2, false), 30);
        gwPanel.setName("StatusBar-GWPanel");
        gwPanel.setBorder(BorderFactory.createEtchedBorder(0, Color.WHITE, Color.LIGHT_GRAY));
        gwPanel.setPreferredSize(new Dimension(80, 17));
        gwPanel.setMaximumSize(this.getPreferredSize());
        this.add(gwPanel);
        this.cancelAction = new CancelAction();
        this.add(new RolloverBorderButton(this.cancelAction){
            {
                this.setPreferredSize(new Dimension(20, 17));
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setToolTipText("Cancel current operation");
                this.setFocusable(false);
            }

            @Override
            public Point getToolTipLocation(MouseEvent event) {
                return new Point(event.getX(), -this.getHeight());
            }
        });
        this.add(new JLabel(SwingHelper.imageIcon("/img/16x16/changed/corner.png")));
    }

    public void setMailService(IMailServiceFacade facade) {
        this.connectivityLabel.setMailServiceFacade(facade);
    }

    @Override
    public void clear() {
        this.displayMessage("");
    }

    @Override
    public String getDisplayedMessage() {
        return this.messageLabel.getText();
    }

    @Override
    public void displayMessage(String text) {
        String txt;
        String string = txt = text != null ? " " + text : text;
        if (SwingUtilities.isEventDispatchThread()) {
            this.messageLabel.setText(txt);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        StatusBar.this.messageLabel.setText(txt);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void setInterrupter(final IWaitingInterrupter interrupter) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.cancelAction.setInterrupter(interrupter);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.cancelAction.setInterrupter(interrupter);
                }
            });
        }
    }

    static class ConnectivityLabel
    extends JLabel {
        static final String IMG_CONNECTING = "/img/16x16/actions/connect_creating.png";
        static final String IMG_OFFLINE = "/img/16x16/actions/connect_no.png";
        static final String IMG_ONLINE = "/img/16x16/actions/connect_established.png";

        ConnectivityLabel() {
            super(SwingHelper.imageIcon(IMG_OFFLINE));
            this.setText("Offline");
        }

        void setMailServiceFacade(IMailServiceFacade facade) {
            if (facade.isOffline()) {
                this.displayOffline();
            } else {
                this.displayOnline();
            }
            facade.addNetworkListener(GenericEDTListener.wrap(new NetworkListener(){

                @Override
                public void connecting() {
                    this.displayConnecting();
                }

                @Override
                public void offline() {
                    this.displayOffline();
                }

                @Override
                public void online() {
                    this.displayOnline();
                }
            }, NetworkListener.class));
        }

        private void displayConnecting() {
            this.setIcon(new BlinkIcon(SwingHelper.imageIcon(IMG_CONNECTING)));
            this.setText("Connecting");
        }

        private void displayOffline() {
            this.setIcon(new BlinkIcon(SwingHelper.imageIcon(IMG_OFFLINE)));
            this.setText("Offline");
        }

        private void displayOnline() {
            this.setIcon(new BlinkIcon(SwingHelper.imageIcon(IMG_ONLINE)));
            this.setText("Online");
        }

        class BlinkIcon
        implements Icon,
        ActionListener {
            Icon icon;
            boolean blink;
            int blinkCount;

            BlinkIcon(Icon icon) {
                this.icon = icon;
                new Timer(500, this).start();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (!this.blink) {
                    this.icon.paintIcon(c, g, x, y);
                }
            }

            @Override
            public int getIconWidth() {
                return this.icon.getIconWidth();
            }

            @Override
            public int getIconHeight() {
                return this.icon.getIconHeight();
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (++this.blinkCount == 10) {
                    ((Timer)evt.getSource()).stop();
                }
                this.blink = this.blinkCount % 2 == 1;
                ConnectivityLabel.this.repaint();
            }
        }
    }

    static class CancelAction
    extends AbstractAction {
        IWaitingInterrupter interrupter;

        public CancelAction() {
            super(null, SwingHelper.imageIcon("/img/16x16/actions/cancel.png"));
            this.setEnabled(false);
        }

        public void setInterrupter(IWaitingInterrupter interrupter) {
            this.interrupter = interrupter;
            this.setEnabled(interrupter != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.interrupter.cancelBackendTask();
        }
    }
}

