/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui;

import com.selima.fbi.CancelException;
import com.selima.fbi.IMailServiceFacade;
import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.MailServiceListenerAdapter;
import com.selima.fbi.MalformedMessageHandler;
import com.selima.fbi.sender.ISenderDetailsManager;
import com.selima.fbi.sender.ISenderDetailsSource;
import com.selima.fbi.sender.SenderDetailsManagerImpl;
import com.selima.fbi.storage.IStorageFactory;
import com.selima.fbi.storage.Transaction;
import com.selima.fbi.threading.GWThreadFactory;
import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.HeaderBar;
import com.selima.fbi.ui.IHeaderBar;
import com.selima.fbi.ui.IMainOptions;
import com.selima.fbi.ui.IStatusBar;
import com.selima.fbi.ui.MailServiceClientContext;
import com.selima.fbi.ui.MainOptions;
import com.selima.fbi.ui.StatusBar;
import com.selima.fbi.ui.common.ToolBar;
import com.selima.fbi.ui.common.waitdlg.BackendWorkInterrupter;
import com.selima.fbi.ui.common.waitdlg.BasicInterrupter;
import com.selima.fbi.ui.common.waitdlg.ShutdownModel;
import com.selima.fbi.ui.common.waitdlg.SingletonWaitingDialog;
import com.selima.fbi.ui.content.ArchiveContent;
import com.selima.fbi.ui.content.DefaultContent;
import com.selima.fbi.ui.content.InboxContent;
import com.selima.fbi.ui.content.IncompleteContent;
import com.selima.fbi.ui.content.ReleaseNotesContent;
import com.selima.fbi.ui.content.SentboxContent;
import com.selima.fbi.ui.content.SubmitContent;
import com.selima.fbi.ui.content.TransferredContent;
import com.selima.fbi.ui.content.credits.LibrariesContent;
import com.selima.fbi.ui.content.settings.SettingsContent;
import com.selima.fbi.ui.logdialog.LoginContext;
import com.selima.fbi.ui.logdialog.LoginDialog;
import com.selima.fbi.user.IReferenceManager;
import com.selima.fbi.user.IUser;
import com.selima.fbi.user.IUserManager;
import com.selima.fbi.user.ReferenceManager;
import com.selima.fbi.user.UserManager;
import com.selima.fbi.webserver.JettyWebServer;
import com.selima.fbi.webserver.WebServer;
import com.selima.fbi.webserver.WebServerException;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.threading.ThreadPoolFactory;
import com.selima.help.ui.HelpInitializer;
import com.selima.help.ui.HelpInitializerSingleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Hashtable;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class MainWindow
extends JPanel
implements MailServiceClientContext,
LoginContext {
    public static final String BACKEND_THREAD_NAME = "Single Backend Thread";
    private Hashtable<String, Object> userdata = new Hashtable();
    private ToolbarPanel rightPanel;
    private ISubmitter submitter;
    private JSplitPane splitPane;
    private StatusBar statusBar;
    private HeaderBar headerBar;
    private MainOptions mainOptions;
    private IStorageFactory storageFactory;
    private IMailServiceFacade mailService;
    private IUserManager userManager;
    private SenderDetailsManagerImpl senderDetailsManager;
    private boolean forcingShutdown;
    private String title;
    private WebServer webServer;
    private ReferenceManager referenceManager;
    private SwingOperationHandle openingHandle;

    public MainWindow() throws IOException {
        super(new BorderLayout());
        new HelpInitializerSingleton();
        this.addAncestorListener(new LoginDialogDisplayer());
        this.submitter = GWThreadFactory.getGWInstance().getCursorSubmitter((JComponent)this, BACKEND_THREAD_NAME);
        this.splitPane = new JSplitPane(1);
        this.headerBar = new HeaderBar();
        this.mainOptions = new MainOptions(this);
        this.statusBar = new StatusBar();
        this.rightPanel = new ToolbarPanel();
        this.add((Component)this.headerBar, "North");
        this.splitPane.setLeftComponent(this.mainOptions);
        this.splitPane.setRightComponent(this.rightPanel);
        this.add((Component)this.splitPane, "Center");
        this.add((Component)this.statusBar, "South");
    }

    private void prepareMainOptions() {
        this.getStatusBar().displayMessage("Attaching Inbox");
        this.mainOptions.insertContent(new InboxContent(this));
        this.getStatusBar().displayMessage("Attaching Transferred");
        this.mainOptions.insertContent(new TransferredContent(this));
        this.getStatusBar().displayMessage("Attaching Archive");
        this.mainOptions.insertContent(new ArchiveContent(this));
        this.getStatusBar().displayMessage("Attaching Submission");
        this.mainOptions.insertContent(new SubmitContent(this));
        this.getStatusBar().displayMessage("Attaching Sent");
        this.mainOptions.insertContent(new SentboxContent(this));
        this.getStatusBar().displayMessage("Attaching Incomplete");
        this.mainOptions.insertContent(new IncompleteContent(this));
        this.getStatusBar().displayMessage("Attaching Settings");
        this.mainOptions.insertContent(new SettingsContent(this));
        this.getStatusBar().displayMessage("Attaching Credits");
        this.mainOptions.insertContent(new LibrariesContent(this));
        this.getStatusBar().displayMessage("Attaching About screen");
        this.mainOptions.insertContent(new ReleaseNotesContent(this));
    }

    @Override
    public void displayContent(final ClientContent content) {
        final ClientContent formerContent = this.rightPanel.getClientContent();
        if (content == formerContent) {
            return;
        }
        if (formerContent != null && !formerContent.canClose()) {
            this.getMainOptions().updateSelection(formerContent);
            return;
        }
        if (this.openingHandle != null && !this.openingHandle.isFinished()) {
            this.openingHandle.cancel();
        }
        this.openingHandle = this.getSubmitter().submitWork(new BackendWork(){

            public String getName() {
                return "Opening " + content.getContentName();
            }

            public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
                handle.checkCancelRequest();
            }

            public void invokeSwing(SwingOperationHandle handle) {
                if (handle.getFailure() == null) {
                    MainWindow.this.displayContentInternal(content, formerContent);
                }
            }
        });
    }

    @Override
    public IMailServiceFacade getMailService() {
        return this.mailService;
    }

    @Override
    public IStorageFactory getStorageFactory() {
        return this.storageFactory;
    }

    @Override
    public IStatusBar getStatusBar() {
        return this.statusBar;
    }

    @Override
    public IMainOptions getMainOptions() {
        return this.mainOptions;
    }

    @Override
    public IHeaderBar getHeaderBar() {
        return this.headerBar;
    }

    @Override
    public IUserManager getUserManager() {
        return this.userManager;
    }

    @Override
    public ISenderDetailsManager getSenderDetailsManager() {
        return this.senderDetailsManager;
    }

    @Override
    public ISenderDetailsSource getSenderDetailsSource() {
        return this.senderDetailsManager;
    }

    @Override
    public IUser getCurrentUser() {
        return this.mailService != null ? this.mailService.getCurrentUser() : null;
    }

    @Override
    public ISubmitter getSubmitter() {
        return this.submitter;
    }

    @Override
    public ISubmitter getNonCursorSubmitter() {
        return GWThreadFactory.getGWInstance().getSubmitter(BACKEND_THREAD_NAME);
    }

    @Override
    public IReferenceManager getReferenceManager() {
        return this.referenceManager;
    }

    @Override
    public String getTitle() {
        if (this.title == null) {
            String version = MailServiceConfig.getInitParameter("release.name", "(Fix me!)");
            if ("@release.name@".equals(version)) {
                version = "(SVN Working Copy)";
            }
            this.title = "Selima File-By-Internet " + version;
        }
        return this.title;
    }

    @Override
    public WebServer getWebServer() throws WebServerException {
        if (this.webServer == null) {
            this.webServer = new JettyWebServer();
        }
        return this.webServer;
    }

    @Override
    public void putValue(String key, Object value) {
        this.userdata.put(key, value);
    }

    @Override
    public Object getValue(String key) {
        return this.userdata.get(key);
    }

    @Override
    public boolean isOnline() {
        return this.mailService != null ? !this.mailService.isOffline() : false;
    }

    private void focusTo(final Component target) {
        Timer timer = new Timer(250, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(target);
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    private void forceShutdown(Component invoker) {
        if (this.forcingShutdown) {
            return;
        }
        this.forcingShutdown = true;
        int res = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(invoker), "The System is Currently awaiting information from\n the HMRC.  If there are problems with\n the network, or at the HMRC this\n information may never be received. Do you\n wish to abandon waiting for this information?", this.getTitle(), 1);
        if (res == 0) {
            new Thread(new ForcedShutdownRunnable()).start();
        } else {
            this.forcingShutdown = false;
        }
    }

    @Override
    public JFrame getMainWindow() {
        return (JFrame)SwingUtilities.getWindowAncestor(this);
    }

    @Override
    public void setMailService(IMailServiceFacade mailService) {
        this.mailService = mailService;
        this.statusBar.setMailService(mailService);
        mailService.addDPSServiceListener(new MailServiceListenerAdapter(){
            int all;

            @Override
            public void noNewMessagesOnServer() {
                System.out.println("No new messages on server");
            }

            @Override
            public void downloadStarted(int sum) {
                System.out.println("Download Started:" + sum);
                this.all = sum;
            }

            @Override
            public void authorizationLost(IUser user, String name) {
                System.out.println("Employer authorization lost:" + name);
            }

            @Override
            public void authorizationGained(IUser user, String name) {
                System.out.println("New Employer detected:" + name);
            }

            @Override
            public void downloaded(String name, int number) {
                System.out.println("Downloaded " + name + " [" + number + "/" + this.all + "]");
            }

            @Override
            public void downloadFinished() {
                System.out.println("Download finished");
            }
        });
    }

    @Override
    public void setStorageFactory(final IStorageFactory storageFactory) throws IOException, CancelException {
        new Transaction(storageFactory).run(new Transaction.InteractionV0(){

            @Override
            public void run() throws IOException, CancelException {
                MainWindow.this.userManager = new UserManager(storageFactory);
                MainWindow.this.referenceManager = new ReferenceManager(storageFactory);
                MainWindow.this.senderDetailsManager = new SenderDetailsManagerImpl(storageFactory);
                MainWindow.this.storageFactory = storageFactory;
            }
        });
    }

    private void displayContentInternal(final ClientContent content, ClientContent formerContent) {
        BackendWork closingWork;
        this.getStatusBar().displayMessage("Loading " + content.getContentName());
        if (formerContent != null && (closingWork = formerContent.getClosingWork()) != null) {
            this.getSubmitter().submitWork(closingWork);
        }
        final BackendWork openingWork = content.getOpeningWork();
        SwingOperationHandle handle = this.getSubmitter().submitWork(new BackendWork(){

            public String getName() {
                return openingWork.getName();
            }

            public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
                openingWork.invokeBackend(handle);
            }

            public void invokeSwing(SwingOperationHandle handle) {
                if (handle.getFailure() != null) {
                    if (!(handle.getFailure() instanceof CanceledException)) {
                        MainWindow.this.getStatusBar().displayMessage("Error " + openingWork.getName());
                        openingWork.invokeSwing(handle);
                    }
                } else {
                    MainWindow.this.getHeaderBar().displayContent(content);
                    MainWindow.this.getMainOptions().updateSelection(content);
                    MainWindow.this.getStatusBar().clear();
                    MainWindow.this.rightPanel.display(content);
                    MainWindow.this.splitPane.setDividerLocation(((MainWindow)MainWindow.this).mainOptions.getPreferredSize().width + MainWindow.this.splitPane.getDividerSize());
                    openingWork.invokeSwing(handle);
                    MainWindow.this.focusTo(MainWindow.this.mainOptions.getSelectedContent() == null ? MainWindow.this.rightPanel : MainWindow.this.mainOptions);
                }
            }
        });
        if (openingWork instanceof BackendWorkInterrupter) {
            ((BackendWorkInterrupter)openingWork).setTaskHandle(handle);
        }
    }

    @Override
    public void showDefaultContent() {
        this.displayContent(new DefaultContent(this));
    }

    class BackendInitializationWork
    implements BackendWork {
        BackendInitializationWork() {
        }

        public String getName() {
            return "Loading...";
        }

        public void invokeBackend(BackendOperationHandle handle) {
            HelpInitializer initializer = HelpInitializerSingleton.getInstance();
            if (initializer != null) {
                initializer.loadHelp("fbi.hs");
                HelpSet hs = initializer.getHelpBroker().getHelpSet();
                if (hs != null) {
                    HelpBroker hb = hs.createHelpBroker();
                    hb.enableHelpKey((Component)MainWindow.this, "content.index", hs, "javax.help.SecondaryWindow", "Popup");
                }
            }
        }

        public void invokeSwing(SwingOperationHandle handle) {
        }
    }

    class ForcedShutdownRunnable
    implements Runnable {
        ForcedShutdownRunnable() {
        }

        @Override
        public void run() {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    ThreadPoolFactory.getInstance().shutDown();
                    MainWindow.this.getMailService().destroy();
                }
            });
            try {
                t.join(7000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    class ShutdownWork
    extends BasicInterrupter
    implements BackendWork {
        ShutdownWork() {
            SingletonWaitingDialog.showDialog(MainWindow.this, new ShutdownModel(10), this);
        }

        public String getName() {
            return "ShutDown";
        }

        public void invokeBackend(BackendOperationHandle p1) {
            IMailServiceFacade mailService = MainWindow.this.getMailService();
            if (mailService != null) {
                mailService.destroy();
            }
        }

        public void invokeSwing(SwingOperationHandle p1) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SwingUtilities.isEventDispatchThread()) {
                        new Thread(this).start();
                    } else {
                        ThreadPoolFactory.getInstance().shutDown();
                        System.exit(0);
                    }
                }
            });
        }

        @Override
        public void cancelBackendTask() {
            MainWindow.this.forceShutdown(MainWindow.this);
        }
    }

    static class ToolbarPanel
    extends JPanel {
        ClientContent clientContent;

        ToolbarPanel() {
            super(new BorderLayout());
            this.setBackground(Color.WHITE);
        }

        void display(ClientContent content) {
            this.removeAll();
            ToolBar toolBar = content.getToolBar();
            if (toolBar != null && toolBar.getComponentCount() > 0) {
                this.add((Component)toolBar, "North");
            }
            this.clientContent = content;
            this.add((Component)content.getContent(), "Center");
        }

        ClientContent getClientContent() {
            return this.clientContent;
        }
    }

    class LoginDialogDisplayer
    extends WindowAdapter
    implements AncestorListener {
        LoginDialogDisplayer() {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            Window w = SwingUtilities.getWindowAncestor(MainWindow.this);
            w.addWindowListener(this);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void windowClosing(final WindowEvent evt) {
            if (MainWindow.this.rightPanel.getClientContent() == null || MainWindow.this.rightPanel.getClientContent().canClose()) {
                BackendWork work;
                if (MainWindow.this.rightPanel.getClientContent() != null && (work = MainWindow.this.rightPanel.getClientContent().getClosingWork()) != null) {
                    MainWindow.this.getSubmitter().submitWork(work);
                }
                ShutdownWork shutdownWork = new ShutdownWork();
                SwingOperationHandle handle = MainWindow.this.getSubmitter().submitWork((BackendWork)shutdownWork);
                shutdownWork.setTaskHandle(handle);
                Timer timer = new Timer(10000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent avt) {
                        MainWindow.this.forceShutdown(evt.getComponent());
                    }
                });
                timer.setRepeats(false);
                timer.start();
            }
        }

        @Override
        public void windowOpened(WindowEvent evt) {
            LoginDialog loginDialog = new LoginDialog(MainWindow.this);
            MainWindow.this.submitter.submitWork((BackendWork)new BackendInitializationWork());
            if (loginDialog.showDialog()) {
                loginDialog = null;
                MainWindow.this.mailService.addDPSServiceListener(new MalformedMessageHandler(MainWindow.this.getTitle(), MainWindow.this.storageFactory));
                IUser user = MainWindow.this.mailService.getCurrentUser();
                MainWindow.this.prepareMainOptions();
                MainWindow.this.getStatusBar().displayMessage("Welcome '" + user.getLogin() + "'");
                MainWindow.this.focusTo(MainWindow.this.mainOptions);
            } else {
                System.exit(0);
            }
        }
    }
}

