/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui;

import com.selima.fbi.ui.ClientContent;
import com.selima.fbi.ui.ClientContext;
import com.selima.fbi.ui.IMainOptions;
import com.selima.help.ui.HelpInitializer;
import com.selima.help.ui.HelpInitializerSingleton;
import com.sun.java.swing.plaf.windows.WindowsBorders;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Stack;
import javax.help.CSH;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MainOptions
extends JPanel
implements IMainOptions {
    private JTree tree;
    private ClientContext cctx;
    private DefaultMutableTreeNode root;

    public MainOptions(ClientContext cctx) {
        super(new BorderLayout());
        this.cctx = cctx;
        this.root = new ClientContentTreeNode(null);
        this.tree = new JTree(new DefaultTreeModel(this.root));
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new MailTreeCellRenderer(this.tree));
        this.tree.setRowHeight(0);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(false);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().addTreeSelectionListener(new MainOptionSelectionListener());
        this.tree.setBorder(new SmartFocusBorder(this.tree));
        JScrollPane treeView = new JScrollPane(this.tree);
        this.add((Component)treeView, "Center");
        this.setPreferredSize(new Dimension(160, 600));
        this.addContextHelp();
    }

    @Override
    public void insertContent(ClientContent content) {
        this.insertContent(content, this.root.getChildCount());
    }

    @Override
    public void insertContent(ClientContent content, int pos) {
        if (pos > this.root.getChildCount()) {
            pos = this.root.getChildCount();
        } else if (pos < 0) {
            pos = 0;
        }
        ((DefaultTreeModel)this.tree.getModel()).insertNodeInto(new ClientContentTreeNode(content), this.root, pos);
        this.tree.expandPath(new TreePath(this.root));
    }

    @Override
    public ClientContent[] getContent() {
        ClientContent[] result = new ClientContent[this.root.getChildCount()];
        for (int i = 0; i < this.root.getChildCount(); ++i) {
            result[i] = ((ClientContentTreeNode)this.root.getChildAt(i)).getContent();
        }
        return result;
    }

    @Override
    public ClientContent getSelectedContent() {
        ClientContent result = null;
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            result = ((ClientContentTreeNode)path.getLastPathComponent()).getContent();
        }
        return result;
    }

    @Override
    public void updateSelection(ClientContent content) {
        Stack<DefaultMutableTreeNode> stack = new Stack<DefaultMutableTreeNode>();
        stack.push(this.root);
        if (!this.searchContent(content, stack)) {
            this.tree.clearSelection();
        }
    }

    private boolean searchContent(ClientContent content, Stack stack) {
        TreeNode parent = (TreeNode)stack.peek();
        Enumeration<? extends TreeNode> it = parent.children();
        while (it.hasMoreElements()) {
            TreeNode child = it.nextElement();
            stack.push(child);
            if (child instanceof ClientContentTreeNode && ((ClientContentTreeNode)child).getContent() == content) {
                TreePath path = new TreePath(stack.toArray());
                this.tree.setSelectionPath(path);
                return true;
            }
            if (this.searchContent(content, stack)) {
                return true;
            }
            stack.pop();
        }
        return false;
    }

    private void addContextHelp() {
        if (HelpInitializerSingleton.getInstance() != null) {
            CSH.addManager((CSH.Manager)new CSHManager());
        }
    }

    class MainOptionSelectionListener
    implements TreeSelectionListener {
        MainOptionSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            if (evt.isAddedPath()) {
                ClientContentTreeNode node = (ClientContentTreeNode)evt.getPath().getLastPathComponent();
                MainOptions.this.cctx.displayContent(node.getContent());
            }
        }
    }

    class ClientContentTreeNode
    extends DefaultMutableTreeNode {
        private ClientContent content;

        ClientContentTreeNode(ClientContent content) {
            this.content = content;
        }

        ClientContent getContent() {
            return this.content;
        }
    }

    class MailTreeCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        Border defaultBorder;
        Border focusedBorder;

        public MailTreeCellRenderer(JTree tree) {
            this.setOpaque(true);
            this.defaultBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 10, 0, 5, tree.getBackground()), BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.focusedBorder = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 10, 0, 5, tree.getBackground()), BorderFactory.createCompoundBorder((Border)new WindowsBorders.DashedBorder((Color)SystemColor.controlText), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            this.setBorder(this.defaultBorder);
            this.setText("MMMMMMMMM");
            this.setIcon(new Icon(){

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                }

                @Override
                public int getIconWidth() {
                    return 32;
                }

                @Override
                public int getIconHeight() {
                    return 32;
                }
            });
            this.setPreferredSize(this.getPreferredSize());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ClientContent content = ((ClientContentTreeNode)value).getContent();
            if (content == null) {
                return this;
            }
            if (sel) {
                this.setForeground(Color.BLACK);
                this.setBackground(new Color(15132410));
                this.setFont(this.getFont().deriveFont(1, 12.0f));
            } else {
                this.setForeground(Color.GRAY);
                this.setBackground(tree.getBackground());
                this.setFont(this.getFont().deriveFont(0, 12.0f));
            }
            this.setIcon(content.getIcon());
            this.setText(content.getContentName());
            this.setToolTipText(content.getDescription());
            this.setBorder(hasFocus ? this.focusedBorder : this.defaultBorder);
            return this;
        }
    }

    class CSHManager
    implements CSH.Manager {
        CSHManager() {
        }

        public HelpSet getHelpSet(Object comp, AWTEvent e) {
            if (comp == MainOptions.this.tree) {
                HelpInitializer hi = HelpInitializerSingleton.getInstance();
                return hi.getHelpBroker().getHelpSet();
            }
            return null;
        }

        public String getHelpIDString(Object comp, AWTEvent evt) {
            if (comp == MainOptions.this.tree && evt instanceof MouseEvent) {
                MouseEvent mevt = (MouseEvent)evt;
                Point p = SwingUtilities.convertPoint((Component)evt.getSource(), mevt.getX(), mevt.getY(), MainOptions.this.tree);
                TreePath path = MainOptions.this.tree.getPathForLocation(p.x, p.y);
                if (path != null) {
                    ClientContent cc = ((ClientContentTreeNode)path.getLastPathComponent()).getContent();
                    return cc.getHelpTopic();
                }
            }
            return null;
        }
    }

    static class SmartFocusBorder
    implements Border,
    FocusListener,
    TreeSelectionListener {
        Border border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10), BorderFactory.createCompoundBorder((Border)new WindowsBorders.DashedBorder((Color)SystemColor.controlText), BorderFactory.createEmptyBorder(10, 0, 0, 0)));
        boolean focused;
        boolean selection;
        JTree tree;

        SmartFocusBorder(JTree tree) {
            this.tree = tree;
            tree.addFocusListener(this);
            tree.getSelectionModel().addTreeSelectionListener(this);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (this.focused && !this.selection) {
                this.border.paintBorder(c, g, x, y, width, height);
            }
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.border.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.focused = true;
            this.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.focused = false;
            this.repaint();
        }

        @Override
        public void valueChanged(TreeSelectionEvent evt) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    selection = tree.getAnchorSelectionPath() != null;
                    this.repaint();
                }
            });
        }

        void repaint() {
            this.tree.repaint();
        }
    }
}

