/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.ui;

import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.threading.GWThreadFactory;
import com.selima.fbi.ui.FBIUncaughtExceptionHandler;
import com.selima.fbi.ui.MainFrame;
import com.selima.fbi.ui.MainWindow;
import com.selima.fbi.ui.common.SwingHelper;
import com.selima.fbi.ui.common.waitdlg.SplashDialog;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.util.logging.LogAPI;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Calendar;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class MailServiceClient {
    private static final String FRAME_ICON_PATH = "/img/32x32/apps/email.png";

    public static void main(final String[] args) throws Exception {
        FBIUncaughtExceptionHandler.install();
        new GWThreadFactory();
        int i = 0;
        String suppLoggerConfig = null;
        while (i < args.length && args[i].startsWith("-D")) {
            String arg;
            if ((arg = args[i++]).equalsIgnoreCase("-Djava.util.logging.config.file")) {
                if (i < args.length) {
                    suppLoggerConfig = args[i++];
                    continue;
                }
                System.err.println("-Djava.util.logging.config.file requires additional parameters");
                continue;
            }
            if (!arg.equalsIgnoreCase("-DforceEnableAxisLog")) continue;
            System.setProperty("forceEnableAxisLog", "true");
        }
        if (suppLoggerConfig != null) {
            MailServiceConfig.setCustomJavaUtilLoggingConfig(suppLoggerConfig);
        }
        final SplashDialog splash = new SplashDialog("Starting...", 3);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                splash.setVisible(true);
            }
        });
        ISubmitter submitter = GWThreadFactory.getGWInstance().getCursorSubmitter((JComponent)splash.getRootPane(), "Startup");
        submitter.submitWork(new BackendWork(){

            public String getName() {
                return "Starting";
            }

            public void invokeBackend(BackendOperationHandle handle) {
                splash.getModel().nextStep("Initializing Look & Feel");
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedLookAndFeelException e) {
                    e.printStackTrace();
                }
                System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
                if (System.getProperty("clientencoding") == null) {
                    System.setProperty("clientencoding", "CP1252");
                }
                splash.getModel().nextStep("Creating Application Window");
                try {
                    MainWindow window = new MainWindow();
                    final MainFrame frame = new MainFrame();
                    frame.setTitle(window.getTitle());
                    frame.setIconImage(SwingHelper.imageIcon(MailServiceClient.FRAME_ICON_PATH).getImage());
                    frame.setDefaultCloseOperation(0);
                    frame.setMainWindow(window);
                    splash.getModel().nextStep("Opening Application Window");
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                            size.width = Math.min(1024, size.width);
                            size.height = Math.min(768, size.height - 30);
                            frame.pack();
                            frame.setSize(size);
                            frame.setLocationRelativeTo(null);
                            frame.setVisible(true);
                        }
                    });
                    MailServiceClient.printStartTime(args);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            splash.dispose();
                        }
                    });
                }
                catch (IOException e) {
                    LogAPI.logSevere((Throwable)e);
                }
                catch (InterruptedException e) {
                    LogAPI.logSevere((Throwable)e);
                }
                catch (InvocationTargetException e) {
                    LogAPI.logSevere((Throwable)e.getCause());
                }
            }

            public void invokeSwing(SwingOperationHandle handle) {
            }
        });
    }

    static void printStartTime(String[] args) {
        if (args.length < 1) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        long endTime = calendar.getTimeInMillis();
        String[] parts = args[0].split("\\.|:|,");
        try {
            calendar.set(11, Integer.parseInt(parts[0]));
            calendar.set(12, Integer.parseInt(parts[1]));
            calendar.set(13, Integer.parseInt(parts[2]));
            calendar.set(14, Integer.parseInt(parts[3]) * 10);
            long result = endTime - calendar.getTimeInMillis();
            System.out.println("Startup time:" + result + " ms");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

