/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.typed;

import com.selima.fbi.core.payebeans.IBeanMessage;
import com.selima.fbi.typed.StorableProperties;
import com.selima.fbi.typed.TypedProperty;
import com.selima.fbi.typed.TypedValuesID;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TypedValues {
    final Map<String, TypedProperty> map;
    final TypedValuesID id;

    public TypedValues(TypedValuesID id) {
        this.id = id;
        List<TypedProperty> values = id.getTypedProperties();
        this.map = new HashMap<String, TypedProperty>(values.size());
        for (TypedProperty typedProperty : values) {
            this.map.put(typedProperty.getName(), typedProperty);
        }
    }

    public void observe(IBeanMessage message) {
        for (TypedProperty typedProperty : this.map.values()) {
            typedProperty.observe(message);
        }
    }

    public void from(StorableProperties properties) {
        for (Map.Entry<Object, Object> entry : properties.toProperties().entrySet()) {
            TypedProperty typedProperty = this.map.get(entry.getKey());
            if (typedProperty == null) continue;
            typedProperty.setTextValue((String)entry.getValue());
        }
    }

    public StorableProperties toProperties() {
        StorableProperties properties = new StorableProperties(this.id.getStoreSpace(), this.id.getStoreId());
        for (TypedProperty typedProperty : this.map.values()) {
            if (!typedProperty.hasValue()) continue;
            properties.toProperties().setProperty(typedProperty.getName(), typedProperty.getTextValue());
        }
        return properties;
    }
}

