/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.typed;

import com.selima.fbi.storage.IStorable;
import com.selima.framework.util.logging.LogAPI;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.InvalidPropertiesFormatException;
import java.util.Properties;

public class StorableProperties
implements IStorable {
    private final Properties properties = new Properties();

    public StorableProperties(String storeSpace, String storeId) {
        this.setStoreSpace(storeSpace);
        this.setStoreId(storeId);
    }

    public StorableProperties(InputStream stream) throws IOException {
        this.load(stream);
    }

    public void save(OutputStream out) throws IOException {
        this.properties.storeToXML(out, "Stored properties for " + this.getStoreId(), "UTF-8");
    }

    public void load(InputStream in) throws IOException {
        try {
            this.properties.loadFromXML(in);
        }
        catch (InvalidPropertiesFormatException e) {
            LogAPI.logSevere((Throwable)e);
        }
    }

    public void setStoreId(String storeId) {
        this.properties.setProperty(this.getClass().getName() + ".storeId", storeId);
    }

    public void setStoreSpace(String storeSpace) {
        this.properties.setProperty(this.getClass().getName() + ".storeSpace", storeSpace);
    }

    @Override
    public String getStoreId() {
        return this.properties.getProperty(this.getClass().getName() + ".storeId");
    }

    @Override
    public String getStoreSpace() {
        return this.properties.getProperty(this.getClass().getName() + ".storeSpace");
    }

    Properties toProperties() {
        return this.properties;
    }
}

