/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.typed;

import com.selima.fbi.core.payebeans.IBean;
import com.selima.fbi.core.payebeans.IResetListener;
import com.selima.fbi.core.payebeans.IResetable;
import com.selima.fbi.typed.Accessor;
import com.selima.fbi.util.ReflectionUtil;
import com.selima.framework.util.logging.LogAPI;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReflectiveAccessor<TargetType, ValueType>
implements Accessor<TargetType, ValueType> {
    static final Pattern EXPRESSION = Pattern.compile("\\.?([^\\(\\)\\.]+)\\(\\)");
    final String expression;
    final String propertyName;
    final Class<?> setterType;
    final Class<ValueType> valueType;
    final LinkedList<String> getters;
    final LinkedList<String> setters;

    ReflectiveAccessor(String getterExpression, Class<ValueType> valueType) {
        this(getterExpression, valueType, valueType);
    }

    ReflectiveAccessor(String getterExpression, Class<ValueType> valueType, Class<?> setterType) {
        String lastName;
        this.valueType = valueType;
        this.setterType = setterType;
        this.expression = getterExpression;
        this.getters = new LinkedList();
        this.setters = new LinkedList();
        Matcher matcher = EXPRESSION.matcher(getterExpression);
        int start = 0;
        while (matcher.find(start)) {
            this.getters.add(matcher.group(1));
            start = matcher.end();
        }
        this.setters.addAll(this.getters.subList(0, this.getters.size() - 1));
        String lastGetter = this.getters.getLast();
        if (lastGetter.startsWith("is")) {
            lastName = lastGetter.substring(2);
        } else {
            assert (lastGetter.startsWith("get"));
            lastName = lastGetter.substring(3);
        }
        this.setters.add("set" + lastName);
        this.propertyName = Character.toLowerCase(lastName.charAt(0)) + lastName.substring(1);
    }

    public String toString() {
        return this.expression;
    }

    @Override
    public ValueType get(TargetType target) {
        return ReflectionUtil.invokeGetter(target, this.valueType, this.getters);
    }

    @Override
    public void set(TargetType target, ValueType value) {
        try {
            ReflectionUtil.invokeSetter(target, this.setters, this.setterType, value);
        }
        catch (InvocationTargetException e) {
            LogAPI.logSevere((Throwable)e.getCause());
        }
    }

    @Override
    public void addPropertyChangeListener(TargetType target, PropertyChangeListener propertyChangeListener) {
        IBean bean = ReflectionUtil.invokeChain(target, this.getters.subList(0, this.getters.size() - 1), IBean.class);
        bean.addPropertyChangeListener(this.propertyName, propertyChangeListener);
    }

    @Override
    public void addResetListener(TargetType target, IResetListener resetListener) {
        IResetable bean = ReflectionUtil.invokeChain(target, this.getters.subList(0, this.getters.size() - 1), IResetable.class);
        bean.addResetListener(this.propertyName, resetListener);
    }
}

