/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.threading;

import com.selima.fbi.threading.IGWImageSupply;
import com.selima.fbi.threading.IGWImageSupplyContext;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class WaitingPanel
extends JPanel
implements IGWImageSupplyContext {
    private IGWImageSupply imageSupply;
    private Timer timer;

    public WaitingPanel(IGWImageSupply imageSupply, int refreshTime) {
        this.imageSupply = imageSupply;
        imageSupply.setContext(this);
        this.timer = new Timer(refreshTime, new TimerListener());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets;
        Dimension result = null;
        if (!this.isPreferredSizeSet() && (result = this.imageSupply.suggestPreferredSize()) != null && (insets = this.getInsets()) != null) {
            result.width += insets.left + insets.right;
            result.height += insets.top + insets.bottom;
        }
        return result == null ? super.getPreferredSize() : result;
    }

    public void start() {
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
        this.imageSupply.reset();
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.imageSupply.paintImage(g);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WaitingPanel.this.imageSupply.switchImage();
            WaitingPanel.this.paintImmediately(0, 0, WaitingPanel.this.getWidth(), WaitingPanel.this.getHeight());
        }
    }
}

