/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.threading;

import com.selima.framework.util.logging.LogAPI;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class WaitCursorManager {
    private static WaitCursorManager instance = new WaitCursorManager();

    public static WaitCursorManager getInstance() {
        return instance;
    }

    protected WaitCursorManager() {
    }

    public synchronized void setWaitCursor(JComponent component) {
        LogAPI.logFine((String)("Setting wait cursor for " + component));
        if (component == null) {
            return;
        }
        JComponent cursorTarget = this.currentCursorTarget(component);
        JComponent formerTarget = this.formerCursorTarget(component);
        if (formerTarget != null && cursorTarget != formerTarget) {
            this.removeWaitCursor(component);
        }
        this.setCursorTarget(component, cursorTarget);
        if (this.incrementCursorCount(cursorTarget) == 1) {
            this.setCursor(cursorTarget, Cursor.getPredefinedCursor(3));
        }
    }

    public synchronized void removeWaitCursor(JComponent component) {
        LogAPI.logFine((String)("Removing wait cursor for " + component));
        if (component == null) {
            return;
        }
        JComponent cursorTarget = this.formerCursorTarget(component);
        if (this.decrementCursorCount(cursorTarget) == 0) {
            this.setCursor(cursorTarget, null);
        }
    }

    private JComponent currentCursorTarget(JComponent component) {
        JComponent target = SwingUtilities.getRootPane(component);
        if (target == null) {
            target = component;
        }
        return target;
    }

    private JComponent formerCursorTarget(JComponent component) {
        return (JComponent)component.getClientProperty("wait-cursor-target");
    }

    private void setCursorTarget(JComponent component, JComponent target) {
        component.putClientProperty("wait-cursor-target", target);
    }

    private void setCursor(final JComponent component, final Cursor cursor) {
        class SettingCursorRunnable
        implements Runnable {
            SettingCursorRunnable() {
            }

            @Override
            public void run() {
                if (component instanceof JRootPane) {
                    Component glassPane = ((JRootPane)component).getGlassPane();
                    glassPane.setCursor(cursor);
                    glassPane.setVisible(cursor != null);
                } else {
                    component.setCursor(cursor);
                }
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            new SettingCursorRunnable().run();
        } else {
            SwingUtilities.invokeLater(new SettingCursorRunnable());
        }
    }

    private int decrementCursorCount(JComponent component) {
        Integer value = (Integer)component.getClientProperty("wait-cursor-count");
        if (value == null || value == 0) {
            throw new IllegalStateException();
        }
        int result = value - 1;
        component.putClientProperty("wait-cursor-count", result);
        return result;
    }

    private int incrementCursorCount(JComponent component) {
        Integer value = (Integer)component.getClientProperty("wait-cursor-count");
        int result = value == null ? 1 : value + 1;
        component.putClientProperty("wait-cursor-count", result);
        return result;
    }
}

