/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.threading;

import com.selima.fbi.threading.IGWThreadFactory;
import com.selima.fbi.threading.WaitCursorManager;
import com.selima.framework.exception.BackendException;
import com.selima.framework.threading.BackendOperationHandle;
import com.selima.framework.threading.BackendWork;
import com.selima.framework.threading.BackendWorkEvent;
import com.selima.framework.threading.BackendWorkEventListener;
import com.selima.framework.threading.CanceledException;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import com.selima.framework.threading.ISubmitter;
import com.selima.framework.threading.IThreadPoolFactory;
import com.selima.framework.threading.NotifyingSubmitter;
import com.selima.framework.threading.SwingOperationHandle;
import com.selima.framework.threading.ThreadPool;
import com.selima.framework.threading.ThreadPoolFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class GWThreadFactory
extends ThreadPoolFactory
implements IGWThreadFactory,
BackendWorkEventListener {
    private IThreadPoolFactory factory;
    private EventBroadcast<BackendWorkEventListener> listeners = SwingEventBroadcastFactory.createEventBroadcast(BackendWorkEventListener.class);

    public GWThreadFactory() {
        this((IThreadPoolFactory)new ThreadPoolFactory());
        ThreadPoolFactory.setInstance((IThreadPoolFactory)this);
    }

    public GWThreadFactory(IThreadPoolFactory factory) {
        this.factory = factory;
        ThreadPoolFactory.setInstance((IThreadPoolFactory)this);
    }

    public ISubmitter getSubmitter(String threadName) {
        return new NotifyingSubmitter(this.factory.getSubmitter(threadName), (BackendWorkEventListener)this);
    }

    public void shutDown() {
        this.factory.shutDown();
    }

    public ThreadPool getThreadPool() {
        return this.factory.getThreadPool();
    }

    public void addBackendWorkEventListener(BackendWorkEventListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removeBackendWorkEventListener(BackendWorkEventListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    public void reset(BackendWorkEvent evt) {
        ((BackendWorkEventListener)this.listeners.getListener()).reset(evt);
    }

    public void startingEvent(BackendWorkEvent evt) {
        ((BackendWorkEventListener)this.listeners.getListener()).startingEvent(evt);
    }

    public void finishningEvent(BackendWorkEvent evt) {
        ((BackendWorkEventListener)this.listeners.getListener()).finishningEvent(evt);
    }

    public BackendWorkEventListener[] getListeners() {
        return (BackendWorkEventListener[])this.listeners.getListeners(BackendWorkEventListener.class);
    }

    public void waitForIdle(int ms) throws InterruptedException {
        SwingOperationHandle handle = this.getThreadPool().submitPrivilegedWork(new BackendWork(){

            public String getName() {
                return "Waiting for idle";
            }

            public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
            }

            public void invokeSwing(SwingOperationHandle handle) {
            }
        });
        handle.waitForFinish((long)ms);
    }

    public static IGWThreadFactory getGWInstance() {
        IThreadPoolFactory factory = ThreadPoolFactory.getInstance();
        if (!(factory instanceof IGWThreadFactory)) {
            return null;
        }
        return (IGWThreadFactory)factory;
    }

    @Override
    public ISubmitter getCursorSubmitter(JComponent comp, String threadName) {
        return new CursorSubmitter(this.getSubmitter(threadName), comp);
    }

    @Override
    public ISubmitter getCursorSubmitter(JComponent comp, ISubmitter submitter) {
        return new CursorSubmitter(submitter, comp);
    }

    static class CursorWork
    implements BackendWork {
        private final BackendWork bwork;
        private final JComponent comp;

        public CursorWork(BackendWork bwork, JComponent comp) {
            this.bwork = bwork;
            this.comp = comp;
            WaitCursorManager.getInstance().setWaitCursor(comp);
        }

        public void invokeBackend(BackendOperationHandle handle) throws BackendException, CanceledException, InterruptedException {
            this.bwork.invokeBackend(handle);
        }

        public void invokeSwing(SwingOperationHandle handle) {
            WaitCursorManager.getInstance().removeWaitCursor(this.comp);
            this.bwork.invokeSwing(handle);
        }

        public String getName() {
            return this.bwork.getName();
        }
    }

    static class CursorSubmitter
    implements ISubmitter {
        JComponent comp;
        ISubmitter submitter;

        CursorSubmitter(ISubmitter submitter, JComponent comp) {
            this.comp = comp;
            this.submitter = submitter;
        }

        public SwingOperationHandle submitWork(BackendWork bwork) {
            return this.submitter.submitWork((BackendWork)new CursorWork(bwork, this.comp));
        }
    }

    static class SwingEventBroadcastFactory
    extends EventBroadcastFactory {
        SwingEventBroadcastFactory() {
        }

        public static <T> EventBroadcast<T> createEventBroadcast(Class<T> iface) {
            return SwingEventBroadcastFactory.createEventBroadcast(iface, new SwingEventBroadcastHandler());
        }

        static class SwingEventBroadcastHandler<T>
        extends EventBroadcastFactory.EventBroadcastHandler<T> {
            SwingEventBroadcastHandler() {
            }

            public Object invoke(final Object proxy, final Method method, final Object[] args) throws Throwable {
                if (SwingUtilities.isEventDispatchThread()) {
                    return super.invoke(proxy, method, args);
                }
                try {
                    final ReturnValueCarrier carrier = new ReturnValueCarrier();
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                carrier.value = SwingEventBroadcastHandler.super.invoke(proxy, method, args);
                            }
                            catch (Throwable tw) {
                                throw new RuntimeCarrierException(tw);
                            }
                        }
                    });
                    return carrier.value;
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof RuntimeCarrierException) {
                        throw ((RuntimeCarrierException)e.getCause()).getCause();
                    }
                    throw e.getCause();
                }
            }

            static class ReturnValueCarrier {
                Object value;

                ReturnValueCarrier() {
                }
            }

            static class RuntimeCarrierException
            extends RuntimeException {
                RuntimeCarrierException(Throwable tw) {
                    super(tw);
                }
            }
        }
    }
}

