/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.threading;

import com.selima.fbi.threading.GWModelEvent;
import com.selima.fbi.threading.GWModelListener;
import com.selima.framework.threading.BackendWorkEvent;
import com.selima.framework.threading.BackendWorkEventListener;
import com.selima.framework.threading.EventBroadcast;
import com.selima.framework.threading.EventBroadcastFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GWModel
implements BackendWorkEventListener {
    private List<Integer> runningList = new ArrayList<Integer>();
    private List<String> nameList = new ArrayList<String>();
    private EventBroadcast<GWModelListener> listeners = EventBroadcastFactory.createEventBroadcast(GWModelListener.class);

    public boolean isRunning() {
        return this.runningList.size() > 0;
    }

    public List<String> getRunningIds() {
        return Collections.unmodifiableList(this.nameList);
    }

    public void finishningEvent(BackendWorkEvent evt) {
        int i = this.runningList.indexOf(new Integer(System.identityHashCode(evt.getWork())));
        if (i != -1) {
            this.runningList.remove(i);
            this.nameList.remove(i);
            if (this.runningList.size() == 0) {
                this.fireStopped();
            }
        }
    }

    public void reset(BackendWorkEvent evt) {
        if (!this.runningList.isEmpty()) {
            this.runningList.clear();
            this.nameList.clear();
            this.fireStopped();
        }
    }

    public void startingEvent(BackendWorkEvent evt) {
        this.runningList.add(new Integer(System.identityHashCode(evt.getWork())));
        this.nameList.add(evt.getWork().getName());
        if (this.runningList.size() == 1) {
            this.fireStarted();
        }
    }

    public void addGWModelListener(GWModelListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removeGWModelListener(GWModelListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void fireStopped() {
        ((GWModelListener)this.listeners).stopped(new GWModelEvent("Stopped"));
    }

    private void fireStarted() {
        ((GWModelListener)this.listeners).started(new GWModelEvent("Started"));
    }
}

