/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.sender;

import com.selima.fbi.hmrcMark.HMRCMark;
import com.selima.fbi.hmrcMark.HMRCMarkException;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.core.IGovTalkMessage;
import com.selima.fbi.submission.core.IKey;
import com.selima.fbi.submission.core.MutableGovTalkMessage;
import com.selima.fbi.submission.core.MutableKey;
import com.selima.fbi.submission.sender.GovTalkMessageSender;
import java.io.IOException;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TPVSGovTalkMessageSender
extends GovTalkMessageSender {
    private InputStream originalSubmission;

    public TPVSGovTalkMessageSender() {
    }

    public TPVSGovTalkMessageSender(String defaultUrl) {
        super(defaultUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IGovTalkMessage send(IGovTalkMessage message, String urlStr) throws IOException, SAXException, SubmitException {
        IGovTalkMessage result = null;
        try {
            if (message.getDetails().getKeys() != null) {
                MutableGovTalkMessage mutableMessage = (MutableGovTalkMessage)message;
                String originalBody = message.getBody();
                String hmrcMark = HMRCMark.hmrcMarkFrom(originalBody.getBytes("UTF-8"));
                if (hmrcMark != null) {
                    this.originalSubmission = message.getXMLStream();
                }
                String taxOfficeNumber = null;
                String taxOfficeReference = null;
                for (IKey key : message.getDetails().getKeys()) {
                    MutableKey mkey = (MutableKey)key;
                    if ("TaxOfficeNumber".equals(mkey.getType())) {
                        taxOfficeNumber = mkey.getBody();
                        mkey.setBody("999");
                        continue;
                    }
                    if (!"TaxOfficeReference".equals(mkey.getType())) continue;
                    taxOfficeReference = mkey.getBody();
                    mkey.setBody("A190");
                }
                String augmentedBody = originalBody.replaceAll("<Key Type=\"TaxOfficeNumber\">\\d+</Key>", "<Key Type=\"TaxOfficeNumber\">999</Key>").replaceAll("<Key Type=\"TaxOfficeReference\">[^<]+</Key>", "<Key Type=\"TaxOfficeReference\">A190</Key>").replaceAll("<OfficeNo>[^<]+</OfficeNo>", "<OfficeNo>999</OfficeNo>").replaceAll("<PayeRef>[^<]+</PayeRef>", "<PayeRef>A190</PayeRef>");
                if (hmrcMark != null) {
                    try {
                        byte[] bytes = augmentedBody.getBytes("UTF-8");
                        byte[] updated = HMRCMark.stripFrom(bytes);
                        String updatedMark = HMRCMark.createFrom(updated);
                        bytes = HMRCMark.addInto(updated, updatedMark);
                        mutableMessage.setBody(bytes);
                    }
                    catch (HMRCMarkException e) {
                        throw new IOException(e);
                    }
                } else {
                    mutableMessage.setBody(augmentedBody);
                }
                try {
                    IGovTalkMessage iGovTalkMessage = result = super.send(message, urlStr);
                    return iGovTalkMessage;
                }
                finally {
                    for (IKey key : message.getDetails().getKeys()) {
                        MutableKey mkey = (MutableKey)key;
                        if ("TaxOfficeNumber".equals(mkey.getType())) {
                            mkey.setBody(taxOfficeNumber);
                            continue;
                        }
                        if (!"TaxOfficeReference".equals(mkey.getType())) continue;
                        mkey.setBody(taxOfficeReference);
                    }
                    ((MutableGovTalkMessage)message).setBody(originalBody);
                }
            }
            IGovTalkMessage iGovTalkMessage = result = super.send(message, urlStr);
            return iGovTalkMessage;
        }
        finally {
            Node xmlSignature;
            if (result != null && this.originalSubmission != null && (xmlSignature = HMRCMark.xmlSignatureOf(result.getXMLStream())) != null) {
                Document irMarkReceipt = HMRCMark.prepareIRmarkReceipt(this.originalSubmission);
                String responseBody = HMRCMark.addIRmarkReceipt(irMarkReceipt, result.getBody());
                ((MutableGovTalkMessage)result).setBody(responseBody);
            }
        }
    }
}

