/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.loader;

import com.selima.fbi.submission.core.IGovTalkMessage;
import com.selima.fbi.submission.core.MutableChannelRouting;
import com.selima.fbi.submission.core.MutableChannelRoutingID;
import com.selima.fbi.submission.core.MutableGatewayValidation;
import com.selima.fbi.submission.core.MutableGovTalkDetails;
import com.selima.fbi.submission.core.MutableGovTalkError;
import com.selima.fbi.submission.core.MutableGovTalkMessage;
import com.selima.fbi.submission.core.MutableHeader;
import com.selima.fbi.submission.core.MutableIDAuthentication;
import com.selima.fbi.submission.core.MutableKey;
import com.selima.fbi.submission.core.MutableMessageDetails;
import com.selima.fbi.submission.core.MutableSenderDetails;
import com.selima.fbi.submission.loader.AbstractSAXLoader;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GovTalkMessageLoader
extends AbstractSAXLoader {
    private MutableGovTalkMessage message = null;
    private MutableHeader header = null;
    private MutableGovTalkDetails govTalkDetails = null;
    private MutableMessageDetails messageDetails;
    private MutableSenderDetails senderDetails;
    private MutableKey key;
    private MutableGatewayValidation gatewayValidation;
    private MutableChannelRouting channelRouting;
    private MutableGovTalkError error;
    private MutableIDAuthentication idAuthentication;
    private MutableChannelRoutingID channelRoutingID;
    private boolean loadBody;
    private boolean msgBodyProcessing = false;

    public IGovTalkMessage load(Object xml, boolean loadBody) throws SAXException, IOException {
        this.message = null;
        this.msgBodyProcessing = false;
        this.loadBody = loadBody;
        this.getParser().parse(this.getInputSource(xml), (DefaultHandler)this);
        return this.message;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.msgBodyProcessing) {
            if (this.loadBody) {
                this.appendBody("<").appendBody(qName).appendBody(this.getAttributesAsText(attributes)).appendBody(">");
            }
            return;
        }
        this.deleteBuffer();
        if ("GovTalkMessage".equals(qName)) {
            this.message = new MutableGovTalkMessage();
        } else if ("Header".equals(qName)) {
            this.header = new MutableHeader();
        } else if ("GovTalkDetails".equals(qName)) {
            this.govTalkDetails = new MutableGovTalkDetails();
        } else if ("Body".equals(qName)) {
            this.msgBodyProcessing = true;
        } else if ("MessageDetails".equals(qName)) {
            this.messageDetails = new MutableMessageDetails();
        } else if ("SenderDetails".equals(qName)) {
            this.senderDetails = new MutableSenderDetails();
        } else if ("Key".equals(qName)) {
            this.key = new MutableKey(attributes.getValue("Type"));
        } else if ("GatewayValidation".equals(qName)) {
            this.gatewayValidation = new MutableGatewayValidation();
        } else if ("ChannelRouting".equals(qName)) {
            this.channelRouting = new MutableChannelRouting();
        } else if ("Error".equals(qName)) {
            this.error = new MutableGovTalkError();
        } else if ("ResponseEndPoint".equals(qName)) {
            String pollInt = attributes.getValue("PollInterval");
            if (pollInt != null) {
                this.messageDetails.setPollInterval(Integer.parseInt(pollInt));
            }
        } else if ("IDAuthentication".equals(qName)) {
            this.idAuthentication = new MutableIDAuthentication();
        } else if ("ID".equals(qName)) {
            this.channelRoutingID = new MutableChannelRoutingID(null, attributes.getValue("Type"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block87: {
            if (this.msgBodyProcessing) {
                if (this.loadBody) {
                    if ("Body".equals(qName)) {
                        this.msgBodyProcessing = false;
                        this.message.setBody(this.getBody());
                    } else {
                        this.appendBody("</").appendBody(qName).appendBody(">");
                    }
                }
                return;
            }
            if ("EnvelopeVersion".equals(qName)) {
                this.message.setEnvelopeVersion(this.getBody());
            } else if ("Header".equals(qName)) {
                this.message.setHeader(this.header);
                this.header = null;
            } else if ("GovTalkDetails".equals(qName)) {
                this.message.setDetails(this.govTalkDetails);
                this.govTalkDetails = null;
            } else if ("MessageDetails".equals(qName)) {
                this.header.setMessageDetails(this.messageDetails);
                this.messageDetails = null;
            } else if ("SenderDetails".equals(qName)) {
                this.header.setSenderDetails(this.senderDetails);
                this.senderDetails = null;
            } else if ("Key".equals(qName)) {
                this.key.setBody(this.getBody());
                this.govTalkDetails.addKey(this.key);
                this.key = null;
            } else if ("Organisation".equals(qName)) {
                this.govTalkDetails.addOrganization(this.getBody());
            } else if ("GatewayValidation".equals(qName)) {
                this.govTalkDetails.setGatewayValidation(this.gatewayValidation);
                this.gatewayValidation = null;
            } else if ("ChannelRouting".equals(qName)) {
                this.govTalkDetails.addChannelRouting(this.channelRouting);
                this.channelRouting = null;
            } else if ("Error".equals(qName)) {
                this.govTalkDetails.addError(this.error);
                this.error = null;
            } else if ("Class".equals(qName)) {
                this.messageDetails.setMsgClass(this.getBody());
            } else if ("Qualifier".equals(qName)) {
                this.messageDetails.setQualifier(this.getBody());
            } else if ("Function".equals(qName)) {
                this.messageDetails.setFunction(this.getBody());
            } else if ("TransactionID".equals(qName)) {
                this.messageDetails.setTransactionID(this.getBody());
            } else if ("AuditID".equals(qName)) {
                this.messageDetails.setAuditID(this.getBody());
            } else if ("CorrelationID".equals(qName)) {
                this.messageDetails.setCorrelationID(this.getBody());
            } else if ("ResponseEndPoint".equals(qName)) {
                this.messageDetails.setResponseEndPoint(this.getBody());
            } else if ("Transformation".equals(qName)) {
                this.messageDetails.setTransformation(this.getBody());
            } else {
                if ("GatewayTest".equals(qName)) {
                    int mode = -1;
                    try {
                        mode = Integer.parseInt(this.getBody());
                        if (mode != 0 && mode != 1) {
                            throw new NumberFormatException("Only 0 and 1 values are allowed");
                        }
                        break block87;
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException("Invalid numeric value defined in element GatewayTest: " + this.getBody(), ex);
                    }
                }
                if ("GatewayTimestamp".equals(qName)) {
                    this.messageDetails.setTimestamp(this.getBody());
                } else if ("IDAuthentication".equals(qName)) {
                    this.senderDetails.setIDAuthentication(this.idAuthentication);
                    this.idAuthentication = null;
                } else if ("X509Certificate".equals(qName)) {
                    this.senderDetails.setX509Certificate(this.getBody());
                } else if ("EmailAddress".equals(qName)) {
                    this.senderDetails.setEmailAddress(this.getBody());
                } else if ("Processed".equals(qName)) {
                    String result = this.getBody();
                    if (result == null || !result.equals("yes") && !result.equals("no")) {
                        throw new SAXException("Invalid content of GatewayValidation/Processed element: " + result);
                    }
                    this.gatewayValidation.setProcessed(result.equals("yes"));
                } else if ("Result".equals(qName)) {
                    String result = this.getBody();
                    if (result == null || !result.equals("pass") && !result.equals("fail")) {
                        throw new SAXException("Invalid content of GatewayValidation/Result element: " + result);
                    }
                    this.gatewayValidation.setAreKeyCredentialsValid(result.equals("yes"));
                } else if ("URI".equals(qName)) {
                    this.channelRouting.setURI(this.getBody());
                } else if ("Name".equals(qName)) {
                    this.channelRouting.setName(this.getBody());
                } else if ("Product".equals(qName)) {
                    this.channelRouting.setProduct(this.getBody());
                } else if ("Version".equals(qName)) {
                    this.channelRouting.setVersion(this.getBody());
                } else if ("ID".equals(qName)) {
                    this.channelRoutingID.setId(this.getBody());
                    this.channelRouting.addID(this.channelRoutingID);
                    this.channelRoutingID = null;
                } else if ("Timestamp".equals(qName)) {
                    this.channelRouting.setTimestamp(null);
                } else if ("RaisedBy".equals(qName)) {
                    this.error.setRaisedBy(this.getBody());
                } else if ("Number".equals(qName)) {
                    this.error.setNumber(Integer.parseInt(this.getBody()));
                } else if ("Type".equals(qName)) {
                    this.error.setType(this.getBody());
                } else if ("Text".equals(qName)) {
                    this.error.addText(this.getBody());
                } else if ("Location".equals(qName)) {
                    this.error.addLocation(this.getBody());
                } else if ("SenderID".equals(qName)) {
                    this.idAuthentication.setSenderID(this.getBody());
                } else if ("Method".equals(qName)) {
                    this.idAuthentication.setMethod(this.getBody());
                } else if ("Role".equals(qName)) {
                    this.idAuthentication.setRole(this.getBody());
                } else if ("Value".equals(qName)) {
                    this.idAuthentication.setValue(this.getBody());
                }
            }
        }
    }
}

