/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.loader;

import com.selima.framework.util.XMLEscaper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AbstractSAXLoader
extends DefaultHandler {
    private StringBuffer body = new StringBuffer();
    protected Locator locator;

    protected SAXParser getParser() {
        SAXParser parser = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            parser = factory.newSAXParser();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parser;
    }

    protected InputSource getInputSource(Object batch) throws IOException {
        if (batch instanceof String) {
            return new InputSource(new StringReader((String)batch));
        }
        if (batch instanceof InputStream) {
            return new InputSource((InputStream)batch);
        }
        if (batch instanceof Reader) {
            return new InputSource((Reader)batch);
        }
        throw new IOException("No suitable type of InputSource!" + (batch != null ? batch.getClass().getName() : null));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.body.append(XMLEscaper.escapeCharData((CharSequence)new CharArraySequence(ch, start, length)));
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.deleteBuffer();
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        System.out.println("Fatal Error - [" + e.getLineNumber() + ":" + e.getColumnNumber() + "] " + e.getMessage() + " " + e.getPublicId() + " " + e.getSystemId());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        System.out.println("Error - [" + e.getLineNumber() + ":" + e.getColumnNumber() + "] " + e.getMessage() + " " + e.getPublicId() + " " + e.getSystemId());
    }

    protected void deleteBuffer() {
        this.body.delete(0, this.body.length());
    }

    protected Date getDate(String dateStr, String pattern) throws SAXException {
        if (dateStr == null && dateStr.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern);
        try {
            return format.parse(dateStr);
        }
        catch (ParseException e) {
            throw new SAXException(e);
        }
    }

    protected String getAttributesAsText(Attributes attributes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < attributes.getLength(); ++i) {
            sb.append(" " + attributes.getQName(i) + "='" + XMLEscaper.escapeAttribute((CharSequence)attributes.getValue(i)) + "'");
        }
        return sb.toString();
    }

    protected AbstractSAXLoader appendBody(CharSequence text) {
        this.body.append(text);
        return this;
    }

    protected String getBody() {
        return this.body.toString();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    static class CharArraySequence
    implements CharSequence {
        char[] array;
        int offset;
        int length;

        public CharArraySequence(char[] array) {
            this(array, 0, array.length);
        }

        public CharArraySequence(char[] array, int offset, int length) {
            this.array = array;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public char charAt(int index) {
            return this.array[this.offset + index];
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new CharArraySequence(this.array, this.offset + start, end - start);
        }
    }
}

