/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.exception;

import com.selima.fbi.core.response.IErrorResponse;
import com.selima.fbi.core.response.IPAYEError;
import com.selima.fbi.core.response.IStorableResponse;
import com.selima.fbi.loader.ResponseLoader;
import com.selima.fbi.submission.IGovTalkResponse;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.core.IGovTalkError;
import java.io.IOException;

public class ErrorResponseException
extends SubmitException {
    String responseBody;
    String govTalkErrors;
    String message;

    public ErrorResponseException(IGovTalkResponse response) {
        super(null, null, response.getCorrelationID(), response.getTimestamp());
        this.responseBody = response.getGovTalkMessage().getBody();
        StringBuilder messageBuilder = new StringBuilder();
        if (this.responseBody != null && this.responseBody.length() > 0) {
            try {
                IStorableResponse parsedResponse = new ResponseLoader().load(this.responseBody);
                if (parsedResponse instanceof IErrorResponse) {
                    IErrorResponse errorResponse = (IErrorResponse)((Object)parsedResponse);
                    IPAYEError error = errorResponse.getErrors().get(0);
                    messageBuilder.append(error.getRaisedBy());
                    messageBuilder.append(' ').append(error.getType());
                    if (error.getErrorCode() != null) {
                        messageBuilder.append(' ').append(error.getErrorCode()).append(": ");
                    }
                    for (String text : error.getTexts()) {
                        messageBuilder.append(' ').append(text);
                    }
                    if (error.getLocation() != null) {
                        messageBuilder.append(' ').append(error.getLocation());
                    }
                }
            }
            catch (IOException e) {
                messageBuilder.append(this.responseBody);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (response.getErrors() != null) {
            for (IGovTalkError error : response.getErrors()) {
                if (messageBuilder.length() == 0) {
                    messageBuilder.append(error.getRaisedBy()).append(' ').append(error.getType()).append(' ').append(error.getNumber()).append(": ");
                    for (String text : error.getTexts()) {
                        messageBuilder.append(' ').append(text);
                    }
                    if (error.getLocations() != null && error.getLocations().length > 0) {
                        messageBuilder.append(error.getLocations()[0]);
                    }
                }
                stringBuilder.append(error.toXML());
            }
        }
        this.govTalkErrors = stringBuilder.toString();
        this.message = messageBuilder.toString();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String getGovTalkErrors() {
        return this.govTalkErrors;
    }

    public String getResponseBody() {
        return this.responseBody;
    }
}

