/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.core.body;

import com.selima.fbi.submission.core.IGovTalkError;
import com.selima.fbi.submission.core.body.IErrorResponse;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MutableErrorResponse
implements IErrorResponse {
    private List errors;

    public MutableErrorResponse() {
    }

    public MutableErrorResponse(IGovTalkError[] errors) {
        if (errors != null) {
            for (int i = 0; i < errors.length; ++i) {
                this.addError(errors[i]);
            }
        }
    }

    @Override
    public IGovTalkError[] getErrors() {
        if (this.errors == null) {
            return null;
        }
        return this.errors.toArray(new IGovTalkError[this.errors.size()]);
    }

    public void addError(IGovTalkError error) {
        if (this.errors == null) {
            this.errors = new LinkedList();
        }
        this.errors.add(error);
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<ErrorResponse xmlns='http://www.govtalk.gov.uk/CM/errorresponse'>");
        sb.append("<Application>\n");
        sb.append("  <MessageCount>" + (this.errors != null ? this.errors.size() : 0) + "</MessageCount>");
        sb.append("</Application>\n");
        if (this.errors != null && this.errors.size() > 0) {
            Iterator iterator = this.errors.iterator();
            while (iterator.hasNext()) {
                sb.append(((IGovTalkError)iterator.next()).toXML() + "\n");
            }
        }
        sb.append("</ErrorResponse>");
        return sb.toString();
    }
}

