/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.core;

import com.selima.fbi.submission.core.IIDAuthentication;

public class MutableIDAuthentication
implements IIDAuthentication {
    private String senderID;
    private String method;
    private String role;
    private String value;

    @Override
    public String getSenderID() {
        return this.senderID;
    }

    public void setSenderID(String senderID) {
        this.senderID = senderID;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        if (!("clear".equals(method) || "MD5".equals(method) || "W3Csigned".equals(method))) {
            throw new IllegalArgumentException("Invalid authentication method: " + method);
        }
        this.method = method;
    }

    @Override
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<IDAuthentication>\n");
        if (this.senderID != null) {
            sb.append("<SenderID>" + this.senderID + "</SenderID>\n");
        }
        if (this.method != null) {
            sb.append("<Authentication>\n");
            sb.append("  <Method>" + this.method + "</Method>\n");
            if (this.role != null) {
                sb.append("<Role>" + this.role + "</Role>\n");
            }
            sb.append("  <Value>" + this.value + "</Value>\n");
            sb.append("</Authentication>\n");
        }
        sb.append("</IDAuthentication>\n");
        return sb.toString();
    }
}

