/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.core;

import com.selima.fbi.submission.core.IGovTalkDetails;
import com.selima.fbi.submission.core.IGovTalkMessage;
import com.selima.fbi.submission.core.IHeader;
import com.selima.fbi.submission.core.SequenceReader;
import com.selima.fbi.submission.core.SequenceStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

public class MutableGovTalkMessage
implements IGovTalkMessage {
    private String envelopeVersion;
    private IHeader header;
    private IGovTalkDetails details;
    private byte[] bodyBytes;
    private String bodyString;

    @Override
    public String getEnvelopeVersion() {
        return this.envelopeVersion;
    }

    public void setEnvelopeVersion(String envelopeVersion) {
        this.envelopeVersion = envelopeVersion;
    }

    @Override
    public IHeader getHeader() {
        return this.header;
    }

    public void setHeader(IHeader header) {
        this.header = header;
    }

    @Override
    public IGovTalkDetails getDetails() {
        return this.details;
    }

    public void setDetails(IGovTalkDetails details) {
        this.details = details;
    }

    @Override
    public String getBody() {
        if (this.bodyBytes != null) {
            try {
                return new String(this.bodyBytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.bodyString;
    }

    public void setBody(String body) {
        this.bodyBytes = null;
        this.bodyString = body;
    }

    public void setBody(byte[] body) {
        this.bodyBytes = body;
        this.bodyString = null;
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getXMLHeader());
        String payload = this.getBody();
        if (payload != null) {
            sb.append(payload);
        }
        sb.append(this.getXMLFooter());
        return sb.toString();
    }

    private String getXMLHeader() {
        StringBuffer sb = new StringBuffer();
        sb.append("<GovTalkMessage  xmlns='http://www.govtalk.gov.uk/CM/envelope'>\n");
        sb.append("  <EnvelopeVersion>" + this.envelopeVersion + "</EnvelopeVersion>\n");
        sb.append(this.header.toXML());
        sb.append(this.details.toXML());
        sb.append("<Body>");
        return sb.toString();
    }

    private String getXMLFooter() {
        return "</Body></GovTalkMessage>\n";
    }

    @Override
    public Reader getXMLReader() {
        SequenceReader reader = new SequenceReader(new StringReader(this.getXMLHeader()), new SequenceReader(this.getBodyReader(), new StringReader(this.getXMLFooter())));
        return reader;
    }

    @Override
    public InputStream getXMLStream() {
        try {
            return new SequenceStream(new ByteArrayInputStream(this.getXMLHeader().getBytes("UTF-8")), this.getBodyStream(), new ByteArrayInputStream(this.getXMLFooter().getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private Reader getBodyReader() {
        try {
            if (this.bodyBytes != null) {
                return new InputStreamReader((InputStream)new ByteArrayInputStream(this.bodyBytes), "UTF-8");
            }
            return new StringReader(this.bodyString != null ? this.bodyString : "");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private InputStream getBodyStream() {
        try {
            if (this.bodyString != null) {
                return new ByteArrayInputStream(this.bodyString.getBytes("UTF-8"));
            }
            return new ByteArrayInputStream(this.bodyBytes != null ? this.bodyBytes : new byte[]{});
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

