/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission.core;

import com.selima.fbi.submission.core.IChannelRouting;
import com.selima.fbi.submission.core.IChannelRoutingID;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MutableChannelRouting
implements IChannelRouting {
    private String uri;
    private String name;
    private String product;
    private String version;
    private List ids;
    private Date timestamp;

    @Override
    public String getURI() {
        return this.uri;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getProduct() {
        return this.product;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public IChannelRoutingID[] getIDs() {
        if (this.ids == null) {
            return null;
        }
        return this.ids.toArray(new IChannelRoutingID[this.ids.size()]);
    }

    public void addID(IChannelRoutingID id) {
        if (this.ids == null) {
            this.ids = new LinkedList();
        }
        this.ids.add(id);
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String toXML() {
        StringBuffer sb = new StringBuffer();
        sb.append("<ChannelRouting>\n");
        sb.append("  <Channel>\n");
        if (this.uri != null) {
            sb.append("  <URI>" + this.uri + "</URI>\n");
        } else if (this.name != null) {
            sb.append("  <Name>" + this.name + "</Name>\n");
        } else {
            throw new RuntimeException("ChannelRouting/Channel URI or Name should be non-null value");
        }
        if (this.product != null) {
            sb.append("  <Product>" + this.product + "</Product>\n");
        }
        if (this.version != null) {
            sb.append("  <Version>" + this.version + "</Version>\n");
        }
        sb.append("  </Channel>\n");
        if (this.ids != null && this.ids.size() > 0) {
            Iterator iterator = this.ids.iterator();
            while (iterator.hasNext()) {
                sb.append(((IChannelRoutingID)iterator.next()).toXML());
            }
        }
        if (this.timestamp != null) {
            sb.append("  <Timestamp>" + this.timestamp + "</Timestamp>\n");
        }
        sb.append("</ChannelRouting>\n");
        return sb.toString();
    }
}

