/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.submission.IGovTalkResponse;
import com.selima.fbi.util.StringUtil;
import com.selima.framework.util.logging.LogAPI;
import java.text.ParseException;
import java.util.Date;

public class SubmitException
extends Exception {
    protected Date date;
    protected String correlationID;

    protected SubmitException(Throwable cause, String message) {
        super(message, cause);
    }

    protected SubmitException(Throwable cause, String message, IGovTalkResponse response) {
        this(cause, message, response.getCorrelationID(), response.getTimestamp());
    }

    protected SubmitException(Throwable cause, String message, String correlationID, String timestamp) {
        super(message, cause);
        this.setCorrelationID(correlationID);
        this.setTimestamp(timestamp);
    }

    protected void setTimestamp(String timestamp) {
        this.date = this.parseTimeStamp(timestamp);
    }

    protected void setCorrelationID(String correlationID) {
        if ("".equals(correlationID)) {
            correlationID = null;
        }
        this.correlationID = correlationID;
    }

    public String getCorrelationID() {
        return this.correlationID;
    }

    public Date getIssueDate() {
        return this.date;
    }

    protected Date parseTimeStamp(String timestamp) {
        if (timestamp != null) {
            try {
                return StringUtil.parseXsdDateTime(timestamp);
            }
            catch (ParseException _e) {
                try {
                    return StringUtil.parseMalformedTPVS_MOVDate(timestamp);
                }
                catch (ParseException __e) {
                    LogAPI.logWarning((String)("Unparsable dateTime: " + timestamp));
                }
            }
        }
        return null;
    }
}

