/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.core.IPAYEMessage;
import com.selima.fbi.core.SubmitClass;
import com.selima.fbi.core.response.IStorableResponse;
import com.selima.fbi.loader.ResponseLoader;
import com.selima.fbi.submission.AbstractSubmissionProcessor;
import com.selima.fbi.submission.GovTalkRequestValidator;
import com.selima.fbi.submission.GovTalkResponse;
import com.selima.fbi.submission.IGovTalkRequest;
import com.selima.fbi.submission.IGovTalkResponse;
import com.selima.fbi.submission.ISubmissionContext;
import com.selima.fbi.submission.ISubmitResult;
import com.selima.fbi.submission.SubmissionState;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.SubmitResult;
import com.selima.fbi.submission.SubmitStoppedException;
import com.selima.fbi.submission.core.IGovTalkError;
import com.selima.fbi.submission.core.IKey;
import com.selima.fbi.submission.core.MutableKey;
import com.selima.fbi.submission.core.body.IStatusReport;
import com.selima.fbi.submission.exception.ErrorResponseException;
import com.selima.fbi.submission.exception.GovTalkValidatorException;
import com.selima.fbi.submission.exception.PollLimitException;
import com.selima.fbi.submission.loader.StatusReportLoader;
import com.selima.fbi.submission.sender.HtmlSubmitException;
import com.selima.fbi.util.StringUtil;
import java.io.IOException;
import java.net.SocketException;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.Date;
import org.xml.sax.SAXException;

public class SubmissionProcessor
extends AbstractSubmissionProcessor {
    public SubmissionProcessor(ISubmissionContext context) {
        super(context);
    }

    @Override
    public ISubmitResult submit(IPAYEMessage data) throws SubmitException, IOException {
        return this.start(data, SubmissionState.INIT, null, data.getFormType().getSubmitClass(false));
    }

    @Override
    public ISubmitResult complete(IPAYEMessage message, SubmitClass submitClass) throws SubmitException, IOException {
        return this.start(message, SubmissionState.POLLING, message.getCorrelationId(), submitClass);
    }

    @Override
    public ISubmitResult validate(IPAYEMessage data) throws SubmitException, IOException {
        return this.start(data, SubmissionState.INIT, null, data.getFormType().getSubmitClass(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ISubmitResult start(IPAYEMessage data, SubmissionState startState, String correlationId, SubmitClass submitClass) throws SubmitException, IOException {
        this.isActive = true;
        this.cancelFlag = false;
        try {
            Date gatewayTimestamp;
            IStorableResponse responsePayload;
            String timestamp;
            IGovTalkResponse successResponse;
            IGovTalkResponse errorBusinessResponse;
            block56: {
                errorBusinessResponse = null;
                successResponse = null;
                GovTalkResponse response = null;
                IGovTalkRequest request = null;
                IGovTalkError error = null;
                int stepCounter = 0;
                String url = this.sender.getDefaultUrl();
                String msgClass = submitClass.toString();
                timestamp = null;
                int pollInterval = 0;
                this.setState(startState);
                try {
                    while (this.getState() != SubmissionState.FINISHED && !this.cancelFlag) {
                        switch (this.getState()) {
                            case INIT: {
                                this.changeState(SubmissionState.SENDING, null, null, url);
                                break;
                            }
                            case SENDING: {
                                if (++stepCounter == this.stepLimit) {
                                    throw new PollLimitException(this.stepLimit, correlationId, timestamp);
                                }
                                request = this.messageFactory.createSubmissionRequest(this.getCurrentUser(), msgClass);
                                request.setBody(data.getBytesForTransmission());
                                request.setKeys(new IKey[]{new MutableKey("TaxOfficeNumber", data.getEmpRef().split("/")[0]), new MutableKey("TaxOfficeReference", data.getEmpRef().split("/")[1])});
                                GovTalkRequestValidator.validateSubmissionRequest(request);
                                this.delay(pollInterval);
                                if (this.cancelFlag) break;
                                response = new GovTalkResponse(this.sender.send(request.getGovTalkMessage(), url));
                                switch (response.getType()) {
                                    case 11: {
                                        this.changeState(SubmissionState.POLLING, request, response, url);
                                        break;
                                    }
                                    case 13: {
                                        this.changeState(SubmissionState.RESPONSE_RECEIVED, request, response, url);
                                        break;
                                    }
                                    case 12: {
                                        error = response.getFirstError();
                                        if ("recoverable".equals(error.getType())) {
                                            this.changeState(SubmissionState.SENDING, request, response, url);
                                            break;
                                        }
                                        if ("business".equals(error.getType())) {
                                            errorBusinessResponse = response;
                                            this.changeState(SubmissionState.DELETING_RESPONSE, request, response, url);
                                            break;
                                        }
                                        this.changeState(SubmissionState.ERROR, request, response, url);
                                        throw new ErrorResponseException(response);
                                    }
                                    default: {
                                        this.changeState(SubmissionState.ERROR, request, response, url);
                                        throw new ErrorResponseException(response);
                                    }
                                }
                                timestamp = response.getTimestamp();
                                url = response.getResponseEndPoint();
                                pollInterval = response.getPollInterval();
                                correlationId = response.getCorrelationID();
                                break;
                            }
                            case POLLING: {
                                if (++stepCounter == this.stepLimit) {
                                    throw new PollLimitException(this.stepLimit, correlationId, timestamp);
                                }
                                request = this.messageFactory.createSubmissionPoll(this.getCurrentUser(), msgClass, correlationId);
                                GovTalkRequestValidator.validateSubmissionPoll(request);
                                this.delay(pollInterval);
                                if (this.cancelFlag) break;
                                response = new GovTalkResponse(this.sender.send(request.getGovTalkMessage(), url));
                                switch (response.getType()) {
                                    case 11: {
                                        this.changeState(SubmissionState.POLLING, request, response, url);
                                        break;
                                    }
                                    case 13: {
                                        this.changeState(SubmissionState.RESPONSE_RECEIVED, request, response, url);
                                        break;
                                    }
                                    case 12: {
                                        error = response.getFirstError();
                                        if ("recoverable".equals(error.getType()) || "fatal".equals(error.getType())) {
                                            this.changeState(SubmissionState.POLLING, request, response, url);
                                            break;
                                        }
                                        if ("business".equals(error.getType())) {
                                            errorBusinessResponse = response;
                                            this.changeState(SubmissionState.DELETING_RESPONSE, request, response, url);
                                            break;
                                        }
                                        this.changeState(SubmissionState.ERROR, request, response, url);
                                        throw new ErrorResponseException(response);
                                    }
                                    default: {
                                        this.changeState(SubmissionState.ERROR, request, response, url);
                                        throw new ErrorResponseException(response);
                                    }
                                }
                                timestamp = response.getTimestamp();
                                url = response.getResponseEndPoint();
                                pollInterval = response.getPollInterval();
                                break;
                            }
                            case RESPONSE_RECEIVED: {
                                successResponse = response;
                                pollInterval = 0;
                                this.changeState(SubmissionState.DELETING_RESPONSE, null, null, null);
                                break;
                            }
                            case DELETING_RESPONSE: {
                                if ("".equals(correlationId) || null == correlationId) {
                                    this.changeState(SubmissionState.FINISHED, request, response, url);
                                    break;
                                }
                                if (++stepCounter == this.stepLimit) {
                                    throw new PollLimitException(this.stepLimit, correlationId, timestamp);
                                }
                                request = this.messageFactory.createDeleteRequest(this.getCurrentUser(), msgClass, correlationId);
                                GovTalkRequestValidator.validateDeleteRequest(request);
                                this.delay(pollInterval);
                                if (this.cancelFlag) break;
                                response = new GovTalkResponse(this.sender.send(request.getGovTalkMessage(), url));
                                switch (response.getType()) {
                                    case 16: {
                                        if (stepCounter < this.stepLimit) {
                                            this.changeState(SubmissionState.DELETING_RESPONSE, request, response, url);
                                            break;
                                        }
                                        throw new PollLimitException(this.stepLimit, correlationId, timestamp);
                                    }
                                    case 15: {
                                        timestamp = response.getTimestamp();
                                        this.changeState(SubmissionState.FINISHED, request, response, url);
                                        break;
                                    }
                                    case 12: {
                                        error = response.getFirstError();
                                        if (error.getNumber() == 2000) {
                                            timestamp = response.getTimestamp();
                                            this.changeState(SubmissionState.FINISHED, request, response, url);
                                            break;
                                        }
                                        if (stepCounter < this.stepLimit) {
                                            this.changeState(SubmissionState.DELETING_RESPONSE, request, response, url);
                                            break;
                                        }
                                        this.changeState(SubmissionState.ERROR, request, response, url);
                                        throw new ErrorResponseException(response);
                                    }
                                    default: {
                                        throw new ErrorResponseException(response);
                                    }
                                }
                                url = response.getResponseEndPoint();
                                pollInterval = response.getPollInterval();
                                timestamp = response.getTimestamp();
                            }
                        }
                    }
                }
                catch (HtmlSubmitException e) {
                    e.setCorrelationID(correlationId);
                    e.setTimestamp(timestamp);
                    throw e;
                }
                catch (GovTalkValidatorException e) {
                    throw new SubmitException(e, e.getMessage(), correlationId, timestamp);
                }
                catch (SAXException e) {
                    throw new SubmitException(e, e.getMessage(), correlationId, timestamp);
                }
                catch (RemoteException e) {
                    throw new SubmitException(e, e.getMessage(), correlationId, timestamp);
                }
                catch (IllegalStateException e) {
                    if (!"Connection is not open".equals(e.getMessage()) && this.cancelFlag) {
                        throw e;
                    }
                }
                catch (IOException e) {
                    if (this.cancelFlag) break block56;
                    if (correlationId != null) {
                        throw new SubmitException(e, e.getMessage(), correlationId, timestamp);
                    }
                    throw e;
                }
            }
            if (this.cancelFlag) {
                this.changeState(SubmissionState.CANCELED, null, null, null);
                throw new SubmitStoppedException(correlationId, timestamp);
            }
            if (errorBusinessResponse != null) {
                responsePayload = new ResponseLoader().load(errorBusinessResponse.getGovTalkMessage().getBody().trim());
            } else {
                String responseBody = successResponse.getGovTalkMessage().getBody();
                if ("".equals(responseBody) || responseBody == null) {
                    responseBody = "<SuccessResponse   xmlns='http://www.inlandrevenue.gov.uk/SuccessResponse'><Message code='9999'>The submission has been accepted silently</Message></SuccessResponse>";
                }
                responsePayload = new ResponseLoader().load(responseBody.trim());
            }
            if ("".equals(timestamp)) {
                gatewayTimestamp = new Date();
            } else {
                try {
                    gatewayTimestamp = StringUtil.parseXsdDateTime(timestamp);
                }
                catch (ParseException _e) {
                    try {
                        gatewayTimestamp = StringUtil.parseMalformedTPVS_MOVDate(timestamp);
                    }
                    catch (ParseException __e) {
                        throw new SubmitException(_e, "Invalid date encountered: " + timestamp, correlationId, timestamp);
                    }
                }
            }
            SubmitResult submitResult = new SubmitResult(gatewayTimestamp, correlationId, responsePayload);
            return submitResult;
        }
        finally {
            this.isActive = false;
        }
    }

    @Override
    public IStatusReport getStatusReport(String submitClass, Date from, Date to) throws SubmitException, IOException {
        this.isActive = true;
        this.cancelFlag = false;
        try {
            GovTalkResponse response;
            IGovTalkRequest request = this.messageFactory.createDataRequest(this.getCurrentUser(), submitClass, from, to);
            try {
                response = new GovTalkResponse(this.sender.send(request.getGovTalkMessage()));
            }
            catch (IOException e) {
                if (this.cancelFlag) {
                    throw new SubmitStoppedException(e);
                }
                throw e;
            }
            catch (SAXException e) {
                throw new SubmitException(e, "Invalid response");
            }
            catch (IllegalStateException e) {
                if (this.cancelFlag && e.getCause() instanceof SocketException && ("socket closed".equals(e.getCause().getMessage()) || "Socket is closed".equals(e.getCause().getMessage()))) {
                    throw new SubmitStoppedException(e.getCause());
                }
                throw e;
            }
            if (response.getType() == 14) {
                try {
                    IStatusReport e = new StatusReportLoader().load(response.getGovTalkMessage().getBody());
                    return e;
                }
                catch (SAXException e) {
                    throw new SubmitException(e, "Invalid response", response);
                }
            }
            throw new ErrorResponseException(response);
        }
        finally {
            this.isActive = false;
        }
    }
}

