/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.NetworkTracker;
import com.selima.fbi.submission.SubmitException;
import com.selima.fbi.submission.core.IGovTalkMessage;
import com.selima.fbi.submission.sender.IGovTalkMessageSender;
import java.io.IOException;
import org.xml.sax.SAXException;

class NetworkTrackingSender
implements IGovTalkMessageSender {
    private IGovTalkMessageSender wrapped;
    private NetworkTracker networkTracker;

    public NetworkTrackingSender(IGovTalkMessageSender sender, NetworkTracker networkTracker) {
        this.networkTracker = networkTracker;
        this.wrapped = sender;
    }

    @Override
    public void cancel() {
        this.wrapped.cancel();
    }

    @Override
    public String getDefaultUrl() {
        return this.wrapped.getDefaultUrl();
    }

    @Override
    public IGovTalkMessage send(IGovTalkMessage message) throws IOException, SAXException, SubmitException {
        this.networkTracker.checkBeforeCommunication();
        try {
            IGovTalkMessage response = this.wrapped.send(message);
            this.networkTracker.checkAfterCommunication();
            return response;
        }
        catch (SAXException e) {
            this.networkTracker.checkOnError(e);
            throw e;
        }
        catch (IOException e) {
            this.networkTracker.checkOnError(e);
            throw e;
        }
    }

    @Override
    public IGovTalkMessage send(IGovTalkMessage message, String urlStr) throws IOException, SAXException, SubmitException {
        this.networkTracker.checkBeforeCommunication();
        try {
            IGovTalkMessage response = this.wrapped.send(message, urlStr);
            this.networkTracker.checkAfterCommunication();
            return response;
        }
        catch (SAXException e) {
            this.networkTracker.checkOnError(e);
            throw e;
        }
        catch (IOException e) {
            this.networkTracker.checkOnError(e);
            throw e;
        }
    }

    @Override
    public void setDefaultUrl(String url) {
        this.wrapped.setDefaultUrl(url);
    }
}

