/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.submission.IGovTalkRequest;
import com.selima.fbi.submission.IGovTalkResponse;
import com.selima.fbi.submission.ISubmissionContext;
import com.selima.fbi.submission.SubmissionProcessor;
import com.selima.fbi.submission.SubmissionState;
import com.selima.fbi.submission.core.IGovTalkMessage;
import com.selima.framework.util.logging.LogAPI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class LoggedSubmissionProcessor
extends SubmissionProcessor {
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss.S");
    private File dir;
    private Writer writer;
    private boolean enablelog;
    private boolean isOpen = false;

    public LoggedSubmissionProcessor(ISubmissionContext context) {
        super(context);
        this.dir = context.getLogDir();
        this.enablelog = context.isLogEnabled();
        this.dir.mkdirs();
    }

    @Override
    protected void changeState(SubmissionState newState, IGovTalkRequest request, IGovTalkResponse response, String url) {
        SubmissionState oldState = this.getState();
        super.changeState(newState, request, response, url);
        if (this.enablelog) {
            if (!(this.isOpen || oldState != SubmissionState.INIT && oldState != SubmissionState.POLLING)) {
                try {
                    this.open();
                    this.writer.write("<submit url='" + url + "'>\n");
                }
                catch (IOException ex) {
                    LogAPI.logSevere((Throwable)ex);
                }
            }
            if (this.isOpen) {
                try {
                    this.writer.write("<transmission oldState='" + (Object)((Object)oldState) + "' newState='" + (Object)((Object)newState) + "'>\n");
                    if (request != null) {
                        this.writer.write("<request>\n");
                        this.writeMessage(request.getGovTalkMessage());
                        this.writer.write("</request>\n");
                    } else {
                        this.writer.write("<request/>\n");
                    }
                    if (response != null) {
                        this.writer.write("<response>\n");
                        this.writeMessage(response.getGovTalkMessage());
                        this.writer.write("</response>\n");
                    } else {
                        this.writer.write("<response/>\n");
                    }
                    this.writer.write("</transmission>\n");
                    this.writer.flush();
                }
                catch (IOException ex) {
                    LogAPI.logSevere((Throwable)ex);
                }
                if (newState == SubmissionState.FINISHED || newState == SubmissionState.ERROR) {
                    this.close();
                }
            }
        }
    }

    private void open() throws IOException {
        this.writer = new FileWriter(new File(this.dir, this.getFileName()));
        this.isOpen = true;
    }

    private void close() {
        if (this.isOpen) {
            try {
                this.writer.write("</submit>");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writer = null;
        }
        this.isOpen = false;
    }

    private String getFileName() {
        return "submission." + format.format(Calendar.getInstance().getTime()) + ".xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMessage(IGovTalkMessage message) throws IOException {
        Reader reader = null;
        try {
            reader = message.getXMLReader();
            int count = -1;
            char[] buff = new char[1024];
            while ((count = reader.read(buff)) != -1) {
                this.writer.write(buff, 0, count);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

