/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.submission.IGovTalkResponse;
import com.selima.fbi.submission.core.IGovTalkError;
import com.selima.fbi.submission.core.IGovTalkMessage;
import com.selima.fbi.submission.core.IMessageDetails;
import com.selima.fbi.submission.core.body.IErrorResponse;
import com.selima.fbi.submission.loader.ErrorResponseLoader;
import com.selima.framework.util.logging.LogAPI;

public class GovTalkResponse
implements IGovTalkResponse {
    private IGovTalkMessage msg;
    private IGovTalkError[] responseErrors;
    private boolean responseErrorsAreLoaded = false;

    public GovTalkResponse(IGovTalkMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException();
        }
        this.msg = msg;
    }

    @Override
    public String getCorrelationID() {
        if (this.msg.getHeader() != null && this.msg.getHeader().getMessageDetails() != null) {
            return this.msg.getHeader().getMessageDetails().getCorrelationID();
        }
        return null;
    }

    @Override
    public String getTimestamp() {
        if (this.msg.getHeader() != null && this.msg.getHeader().getMessageDetails() != null) {
            return this.msg.getHeader().getMessageDetails().getTimestamp();
        }
        return null;
    }

    @Override
    public String getTransformation() {
        if (this.msg.getHeader() != null && this.msg.getHeader().getMessageDetails() != null) {
            return this.msg.getHeader().getMessageDetails().getTransformation();
        }
        return null;
    }

    @Override
    public String getResponseEndPoint() {
        if (this.msg.getHeader() != null && this.msg.getHeader().getMessageDetails() != null) {
            return this.msg.getHeader().getMessageDetails().getResponseEndPoint();
        }
        return null;
    }

    @Override
    public int getPollInterval() {
        if (this.msg.getHeader() != null && this.msg.getHeader().getMessageDetails() != null) {
            return this.msg.getHeader().getMessageDetails().getPollInterval();
        }
        LogAPI.logWarning((String)"No value for pollInterval found in response. Default 2 seconds is returned instead!");
        return 2;
    }

    @Override
    public IGovTalkError[] getErrors() {
        if (this.msg.getDetails() != null) {
            return this.msg.getDetails().getErrors();
        }
        return null;
    }

    @Override
    public IGovTalkError getFirstError() {
        IGovTalkError[] errors = this.getErrors();
        if (errors != null && errors.length > 0) {
            return errors[0];
        }
        return null;
    }

    @Override
    public IGovTalkError[] getResponseErrors() {
        if (this.getType() != 12 || this.getFirstError() == null || !"business".equals(this.getFirstError().getType())) {
            return null;
        }
        if (this.responseErrorsAreLoaded) {
            return this.responseErrors;
        }
        ErrorResponseLoader loader = new ErrorResponseLoader();
        IErrorResponse errorResponse = null;
        try {
            errorResponse = loader.load(this.msg.getBody());
            this.responseErrorsAreLoaded = true;
        }
        catch (Throwable e) {
            LogAPI.logSevere((String)"can't load error reponse from govtalkmessage body element", (Throwable)e);
        }
        if (errorResponse != null) {
            this.responseErrors = errorResponse.getErrors();
        }
        return this.responseErrors;
    }

    @Override
    public IGovTalkError getFirstResponseError() {
        IGovTalkError[] errors = this.getResponseErrors();
        if (errors == null || errors.length == 0) {
            return null;
        }
        return errors[0];
    }

    @Override
    public IGovTalkMessage getGovTalkMessage() {
        return this.msg;
    }

    @Override
    public int getType() {
        if (this.msg == null) {
            return -1;
        }
        IMessageDetails details = this.msg.getHeader().getMessageDetails();
        String qualifier = details.getQualifier();
        String function = details.getFunction();
        if ("acknowledgement".equals(qualifier) && "submit".equals(function)) {
            return 11;
        }
        if ("error".equals(qualifier) && "submit".equals(function)) {
            return 12;
        }
        if ("response".equals(qualifier) && "submit".equals(function)) {
            return 13;
        }
        if ("response".equals(qualifier) && "list".equals(function)) {
            return 14;
        }
        if ("response".equals(qualifier) && "delete".equals(function)) {
            return 15;
        }
        if ("acknowledgement".equals(qualifier) && "delete".equals(function)) {
            return 16;
        }
        return -1;
    }
}

