/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.submission;

import com.selima.fbi.MailServiceConfig;
import com.selima.fbi.submission.GovTalkRequest;
import com.selima.fbi.submission.IGovTalkMessageFactory;
import com.selima.fbi.submission.IGovTalkRequest;
import com.selima.fbi.submission.core.ISenderDetails;
import com.selima.fbi.submission.core.MutableGovTalkMessage;
import com.selima.fbi.submission.core.MutableMessageDetails;
import com.selima.fbi.submission.core.MutableSenderDetails;
import com.selima.fbi.submission.core.body.MutableStatusReportRange;
import com.selima.fbi.submission.exception.GovTalkMessageCreateException;
import com.selima.fbi.submission.loader.GovTalkMessageLoader;
import com.selima.fbi.user.IUser;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.xml.sax.SAXException;

public class GovTalkMessageFactory
implements IGovTalkMessageFactory {
    private GovTalkMessageLoader loader = new GovTalkMessageLoader();

    @Override
    public IGovTalkRequest createSubmissionRequest(IUser user, String msgClass) throws GovTalkMessageCreateException {
        return this.load(user, msgClass, "submission-request.xml", false);
    }

    @Override
    public IGovTalkRequest createSubmissionPoll(IUser user, String msgClass, String correlationID) throws GovTalkMessageCreateException {
        IGovTalkRequest request = this.load(user, msgClass, "submission-poll.xml", false);
        request.setCorrelationID(correlationID);
        return request;
    }

    @Override
    public IGovTalkRequest createDeleteRequest(IUser user, String msgClass, String correlationID) throws GovTalkMessageCreateException {
        IGovTalkRequest request = this.load(user, msgClass, "delete-request.xml", false);
        request.setCorrelationID(correlationID);
        return request;
    }

    @Override
    public IGovTalkRequest createDataRequest(IUser user, String msgClass, Date from, Date to) throws GovTalkMessageCreateException {
        IGovTalkRequest request = this.load(user, msgClass, "data-request.xml", false);
        MutableGovTalkMessage msg = (MutableGovTalkMessage)request.getGovTalkMessage();
        MutableStatusReportRange range = new MutableStatusReportRange();
        SimpleDateFormat format = new SimpleDateFormat();
        format.applyPattern("dd/MM/yyyy");
        if (from != null) {
            range.setStartDate(format.format(from));
        }
        if (to != null) {
            range.setEndDate(format.format(to));
        }
        format.applyPattern("HH:mm:ss");
        if (from != null) {
            range.setStartTime(format.format(from));
        }
        if (to != null) {
            range.setEndTime(format.format(to));
        }
        msg.setBody(range.toXML());
        ((MutableMessageDetails)msg.getHeader().getMessageDetails()).setMsgClass(msgClass);
        return request;
    }

    private IGovTalkRequest load(IUser user, String msgClass, String resource, boolean loadBody) throws GovTalkMessageCreateException {
        MutableGovTalkMessage govTalkMessage;
        InputStream is = this.getDataInputStream("prototypes/" + resource);
        if (is == null) {
            throw new GovTalkMessageCreateException("Resource '" + resource + "' not found ");
        }
        try {
            govTalkMessage = (MutableGovTalkMessage)this.loader.load(is, loadBody);
        }
        catch (SAXException e) {
            throw new GovTalkMessageCreateException("Invalid resource format '" + resource + "'", e);
        }
        catch (IOException e) {
            throw new GovTalkMessageCreateException("Unreadable resource '" + resource + "'", e);
        }
        ISenderDetails senderDetails = govTalkMessage.getHeader().getSenderDetails();
        if (senderDetails instanceof MutableSenderDetails) {
            ((MutableSenderDetails)senderDetails).setEmailAddress(user.getEmailAddress());
        }
        return new GovTalkRequest(govTalkMessage, user, msgClass);
    }

    private InputStream getDataInputStream(String resource) throws GovTalkMessageCreateException {
        InputStream result = MailServiceConfig.getResourceAsStream(resource);
        return result;
    }
}

