/*
 * Decompiled with CFR 0.152.
 */
package com.selima.fbi.storage.uv;

import com.selima.fbi.storage.StorageId;
import com.selima.fbi.storage.uv.UvStorageConstants;
import com.selima.framework.util.Util;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class UvStorageFileNames {
    UvStorageFileNames() {
    }

    static String createDataFileName(String alias, String outerSpace, String innerSpace) {
        if (Util.isEmpty((Object)alias)) {
            throw new IllegalArgumentException("alias is empty");
        }
        String fileName = "FBI_" + UvStorageFileNames.encodeNamePart(alias);
        if (Util.isEmpty((Object)outerSpace)) {
            throw new IllegalArgumentException("outerSpace is empty");
        }
        fileName = fileName + "_" + UvStorageFileNames.encodeNamePart(outerSpace);
        if (!Util.isEmpty((Object)innerSpace)) {
            fileName = fileName + "_" + UvStorageFileNames.encodeNamePart(innerSpace);
        }
        return fileName;
    }

    static String createIndexFileName(String alias, String outerSpace, String innerSpace) {
        return UvStorageFileNames.createDataFileName(alias, outerSpace, innerSpace) + ".index";
    }

    static StorageId createStorageId(String fileName) {
        if (fileName == null || fileName.endsWith(".index")) {
            return null;
        }
        Pattern pattern = "__".length() >= "_".length() ? Pattern.compile(Pattern.quote("__") + "|" + Pattern.quote("_")) : Pattern.compile(Pattern.quote("_") + "|" + Pattern.quote("__"));
        Matcher matcher = pattern.matcher(fileName);
        LinkedList<String> parts = new LinkedList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            if ("_".equals(matcher.group())) {
                matcher.appendReplacement(stringBuffer, "");
                parts.add(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            matcher.appendReplacement(stringBuffer, "$0");
        }
        matcher.appendTail(stringBuffer);
        if (stringBuffer.length() > 0) {
            parts.add(stringBuffer.toString());
        }
        if (parts.size() < 3 || parts.size() > 4) {
            return null;
        }
        if (!"FBI".equals(parts.get(0))) {
            return null;
        }
        String alias = UvStorageFileNames.decodeNamePart((String)parts.get(1));
        if (Util.isEmpty((Object)alias)) {
            return null;
        }
        String outerSpace = UvStorageFileNames.decodeNamePart((String)parts.get(2));
        if (Util.isEmpty((Object)outerSpace)) {
            return null;
        }
        String innerSpace = null;
        if (parts.size() > 3) {
            innerSpace = UvStorageFileNames.decodeNamePart((String)parts.get(3));
        }
        StorageId storageId = new StorageId(alias, outerSpace, innerSpace);
        return storageId;
    }

    static String encodeNamePart(String namePart) {
        if (namePart == null) {
            return null;
        }
        for (String[] pair : UvStorageConstants.NAME_REPLACEMENTS) {
            namePart = namePart.replaceAll(Pattern.quote(pair[0]), pair[1]);
        }
        return namePart;
    }

    static String decodeNamePart(String namePart) {
        if (namePart == null) {
            return null;
        }
        for (String[] pair : UvStorageConstants.NAME_REPLACEMENTS) {
            namePart = namePart.replaceAll(Pattern.quote(pair[1]), pair[0]);
        }
        return namePart;
    }
}

